/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datatype;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.datatype.AbstractDataType;
import com.pmease.quickbuild.plugin.report.engine.exception.DatabaseException;
import com.pmease.quickbuild.plugin.report.engine.exception.ParseException;
import com.pmease.quickbuild.plugin.report.engine.exception.TypeCastException;
import com.pmease.quickbuild.plugin.report.engine.util.XMLHelper;
import com.pmease.quickbuild.util.ExceptionUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import org.dom4j.Element;
import org.dom4j.Node;

public class EnumType
extends AbstractDataType {
    private static final long serialVersionUID = 1L;
    private Class enumClass;
    private String[] enumValues;

    public EnumType() {
    }

    public EnumType(String[] values) {
        this.enumValues = values;
    }

    public EnumType(Class enumClass) {
        this.enumValues = EnumType.getEnumConstants(enumClass);
        this.enumClass = enumClass;
    }

    @Override
    public void fromXML(Element node) {
        super.fromXML(node);
        if (this.enumClass != null || this.enumValues != null) {
            return;
        }
        String clazz = XMLHelper.getString((Node)node, "enumClass");
        this.enumValues = XMLHelper.getStringArray((Node)node, "values");
        if (!Strings.isNullOrEmpty((String)clazz)) {
            try {
                this.enumClass = Class.forName(clazz);
                this.enumValues = EnumType.getEnumConstants(this.enumClass);
            }
            catch (ClassNotFoundException e) {
                throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
            }
        }
        if (this.enumValues.length <= 0) {
            throw new ParseException("For 'enum' data type, either 'enumClass' or 'values' should be defined.");
        }
    }

    static String[] getEnumConstants(Class enumClass) {
        T[] values = enumClass.getEnumConstants();
        ArrayList list = Lists.newArrayList();
        for (Object each : values) {
            list.add(each.toString());
        }
        return (String[])Iterables.toArray((Iterable)list, String.class);
    }

    public String[] getValues() {
        return this.enumValues;
    }

    @Override
    public Object fromString(String str, String pattern, Locale locale) {
        if (Strings.isNullOrEmpty((String)str)) {
            return null;
        }
        if (this.enumClass != null) {
            return Enum.valueOf(this.enumClass, str);
        }
        return str;
    }

    @Override
    public String asString(Object value, String pattern, Locale locale) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (this.enumClass != null && this.enumClass.isAssignableFrom(value.getClass())) {
            return ((Enum)value).name();
        }
        throw new TypeCastException(value, this);
    }

    @Override
    public Object typeCast(Object from) {
        if (from == null) {
            return null;
        }
        if (from instanceof String) {
            return this.fromString((String)from);
        }
        if (this.enumClass != null && this.enumClass.isAssignableFrom(from.getClass())) {
            return from;
        }
        throw new TypeCastException(from, this);
    }

    @Override
    public String getDefaultPattern() {
        return null;
    }

    @Override
    public Class<?> getReturnedClass() {
        return Enum.class;
    }

    @Override
    public String getSqlType() {
        return "VARCHAR";
    }

    @Override
    public Object asDbObject(Object original) {
        return this.asString(original);
    }

    public Object fromDbObject(Object original) {
        return this.fromString((String)original);
    }

    @Override
    public String getType() {
        return "ENUM";
    }

    @Override
    public void toXML(Element node) {
        super.toXML(node);
        node.addAttribute("values", Joiner.on((char)',').join((Object[])this.getValues()));
    }

    @Override
    public Object fromDbObject(ResultSet rs, String columnName) {
        try {
            String str = rs.getString(columnName);
            return this.typeCast(str);
        }
        catch (SQLException e) {
            throw new DatabaseException("Retrieve column " + columnName + " with data type " + this + " failed.", e);
        }
    }
}

