/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datatype;

import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.report.engine.datatype.LongType;
import com.pmease.quickbuild.plugin.report.engine.util.DurationFormatUtils;
import java.math.BigDecimal;
import java.util.Locale;
import org.apache.commons.validator.routines.BigDecimalValidator;
import org.joda.time.Chronology;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadablePeriod;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.PeriodFormatter;

public class DurationType
extends LongType {
    private static final long serialVersionUID = 1L;
    public static final String FMT_WORD = "WORD";
    public static final String FMT_ISO = "ISO";
    public static final String FMT_SHORT_WORD = "SHORT";

    @Override
    public String getType() {
        return "DURATION";
    }

    @Override
    public String asString(Object value, String pattern, Locale locale) {
        Long mills = this.typeCast(value);
        if (mills == null) {
            return null;
        }
        if (Strings.isNullOrEmpty((String)pattern)) {
            return mills.toString();
        }
        if (mills == 0L) {
            return "0 mil";
        }
        if (mills < 1000L) {
            return mills + " mils";
        }
        PeriodFormatter fmt = this.getFormatter(pattern, locale);
        Duration duration = new Duration((Object)mills);
        return fmt.print((ReadablePeriod)duration.toPeriod(PeriodType.yearMonthDayTime(), (Chronology)ISOChronology.getInstanceUTC()));
    }

    protected PeriodFormatter getFormatter(String pattern, Locale locale) {
        PeriodFormatter fmt = null;
        fmt = FMT_WORD.equalsIgnoreCase(pattern) ? DurationFormatUtils.wordFormatter() : (FMT_ISO.equalsIgnoreCase(pattern) ? DurationFormatUtils.isoFormatter() : (FMT_SHORT_WORD.equalsIgnoreCase(pattern) ? DurationFormatUtils.shortWordFormatter() : DurationFormatUtils.createPeriodFormatter(pattern)));
        if (locale != null) {
            fmt = fmt.withLocale(locale);
        }
        return fmt;
    }

    @Override
    public String getDefaultPattern() {
        return FMT_SHORT_WORD;
    }

    @Override
    public Object fromString(String str, String pattern, Locale locale) {
        if (Strings.isNullOrEmpty((String)str)) {
            return null;
        }
        if ("NaN".equalsIgnoreCase(str)) {
            return new Long(0L);
        }
        if (Strings.isNullOrEmpty((String)pattern)) {
            try {
                return Long.valueOf(str);
            }
            catch (NumberFormatException e) {
                BigDecimal number = BigDecimalValidator.getInstance().validate(str, locale);
                if (number != null) {
                    return ((Number)number).longValue();
                }
                return 0;
            }
        }
        PeriodFormatter formatter = this.getFormatter(pattern, locale);
        Period period = formatter.parsePeriod(str);
        return period.toStandardDuration().getMillis();
    }

    public static void main(String[] args) {
        System.out.println(Locale.getDefault());
    }
}

