/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datatype;

import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.report.engine.datatype.AbstractNumericType;
import com.pmease.quickbuild.plugin.report.engine.exception.DatabaseException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.commons.validator.routines.DoubleValidator;

public class DoubleType
extends AbstractNumericType {
    private static final long serialVersionUID = 1L;

    @Override
    public Object fromString(String str, String pattern, Locale locale) {
        if (Strings.isNullOrEmpty((String)str)) {
            return null;
        }
        if (Strings.isNullOrEmpty((String)pattern)) {
            return Double.valueOf(str);
        }
        return DoubleValidator.getInstance().validate(str, pattern, locale);
    }

    @Override
    public String asString(Object value, String pattern, Locale locale) {
        Double d = this.typeCast(value);
        if (d == null || d.isNaN() || d.isInfinite()) {
            return null;
        }
        if (Strings.isNullOrEmpty((String)pattern)) {
            return d.toString();
        }
        return DoubleValidator.getInstance().format((Object)d, pattern, locale);
    }

    @Override
    public Double getDefaultValue() {
        return 0.0;
    }

    @Override
    public Double typeCast(Object from) {
        Number n = this.toNumber(from);
        if (n == null) {
            return null;
        }
        return n.doubleValue();
    }

    @Override
    public String getDefaultPattern() {
        return "#,##0.00";
    }

    @Override
    public Class<?> getReturnedClass() {
        return Double.class;
    }

    @Override
    public String getSqlType() {
        return "DOUBLE";
    }

    @Override
    public String getType() {
        return "DOUBLE";
    }

    @Override
    public Object fromDbObject(ResultSet rs, String columnName) {
        try {
            return rs.getDouble(columnName);
        }
        catch (SQLException e) {
            throw new DatabaseException("Retrieve column " + columnName + " with data type " + this + " failed.", e);
        }
    }
}

