/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datatype;

import com.google.common.base.Strings;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.plugin.report.engine.datatype.AbstractDataType;
import com.pmease.quickbuild.plugin.report.engine.exception.DatabaseException;
import com.pmease.quickbuild.plugin.report.engine.exception.TypeCastException;
import com.pmease.quickbuild.util.DateUtils;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Locale;
import org.apache.commons.validator.routines.DateValidator;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

public class DateType
extends AbstractDataType {
    private static final long serialVersionUID = 1L;

    @Override
    public Object fromString(String str, String pattern, Locale locale) {
        if (Strings.isNullOrEmpty((String)str)) {
            return null;
        }
        if (Strings.isNullOrEmpty((String)pattern)) {
            try {
                Long mills = Long.valueOf(str);
                if (mills != null) {
                    return new java.util.Date(mills);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            DateTime dt = ISODateTimeFormat.dateTime().parseDateTime(str);
            if (dt == null) {
                throw new TypeCastException((Object)str, this);
            }
            return dt.toDate();
        }
        return DateValidator.getInstance().validate(str, pattern, locale, Context.getTimeZone());
    }

    @Override
    public String asString(Object value, String pattern, Locale locale) {
        java.util.Date date = this.typeCast(value);
        if (date == null) {
            return null;
        }
        if (Strings.isNullOrEmpty((String)pattern)) {
            return ISODateTimeFormat.dateTime().print((ReadableInstant)new DateTime((Object)date));
        }
        if ("age".equalsIgnoreCase(pattern)) {
            return DateUtils.formatAge((java.util.Date)date);
        }
        return DateValidator.getInstance().format((Object)date, pattern, locale, Context.getTimeZone());
    }

    @Override
    public java.util.Date typeCast(Object other) {
        if (other == null) {
            return null;
        }
        if (other instanceof java.util.Date) {
            return (java.util.Date)other;
        }
        if (other instanceof Date) {
            long mills = ((Date)other).getTime();
            return new java.util.Date(mills);
        }
        if (other instanceof Time) {
            long mills = ((Time)other).getTime();
            return new java.util.Date(mills);
        }
        if (other instanceof Timestamp) {
            long mills = ((Timestamp)other).getTime();
            return new java.util.Date(mills);
        }
        if (other instanceof Calendar) {
            long mills = ((Calendar)other).getTimeInMillis();
            return new java.util.Date(mills);
        }
        if (other instanceof Number) {
            long mills = ((Number)other).longValue();
            return new java.util.Date(mills);
        }
        if (other instanceof String) {
            return (java.util.Date)this.fromString((String)other);
        }
        throw new TypeCastException(other, this);
    }

    @Override
    public String getDefaultPattern() {
        return "MMM dd, yyyy";
    }

    @Override
    public Class<?> getReturnedClass() {
        return java.util.Date.class;
    }

    @Override
    public String getSqlType() {
        return "DATE";
    }

    @Override
    public Object asDbObject(Object original) {
        java.util.Date date = this.typeCast(original);
        if (date == null) {
            return null;
        }
        return new Date(date.getTime());
    }

    public Object fromDbObject(Object original) {
        return this.typeCast(original);
    }

    @Override
    public String getType() {
        return "DATE";
    }

    @Override
    public Object fromDbObject(ResultSet rs, String columnName) {
        try {
            Date date = rs.getDate(columnName);
            return this.typeCast(date);
        }
        catch (SQLException e) {
            throw new DatabaseException("Retrieve column " + columnName + " with data type " + this + " failed.", e);
        }
    }
}

