/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datatype;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.plugin.report.engine.commons.LevelType;
import com.pmease.quickbuild.plugin.report.engine.commons.TestStatusType;
import com.pmease.quickbuild.plugin.report.engine.datatype.BlobType;
import com.pmease.quickbuild.plugin.report.engine.datatype.BlockType;
import com.pmease.quickbuild.plugin.report.engine.datatype.BooleanType;
import com.pmease.quickbuild.plugin.report.engine.datatype.BuildType;
import com.pmease.quickbuild.plugin.report.engine.datatype.ByteType;
import com.pmease.quickbuild.plugin.report.engine.datatype.ChangesetIdType;
import com.pmease.quickbuild.plugin.report.engine.datatype.ClobType;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataSizeType;
import com.pmease.quickbuild.plugin.report.engine.datatype.DateType;
import com.pmease.quickbuild.plugin.report.engine.datatype.DoubleType;
import com.pmease.quickbuild.plugin.report.engine.datatype.DurationType;
import com.pmease.quickbuild.plugin.report.engine.datatype.EnumType;
import com.pmease.quickbuild.plugin.report.engine.datatype.FloatType;
import com.pmease.quickbuild.plugin.report.engine.datatype.HashSetType;
import com.pmease.quickbuild.plugin.report.engine.datatype.IdType;
import com.pmease.quickbuild.plugin.report.engine.datatype.IntegerType;
import com.pmease.quickbuild.plugin.report.engine.datatype.ListType;
import com.pmease.quickbuild.plugin.report.engine.datatype.LongType;
import com.pmease.quickbuild.plugin.report.engine.datatype.ObjectType;
import com.pmease.quickbuild.plugin.report.engine.datatype.PercentType;
import com.pmease.quickbuild.plugin.report.engine.datatype.StringType;
import com.pmease.quickbuild.plugin.report.engine.datatype.TimeType;
import com.pmease.quickbuild.plugin.report.engine.exception.ParseException;
import com.pmease.quickbuild.plugin.report.engine.exception.UnknownTypeException;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import com.pmease.quickbuild.plugin.report.engine.util.TypedObjectMap;
import com.pmease.quickbuild.plugin.report.engine.util.TypedObjects;
import com.pmease.quickbuild.plugin.report.engine.util.XMLHelper;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.dom4j.Node;

public class DataTypes {
    public static final DataType BOOLEAN = new BooleanType();
    public static final DataType INTEGER = new IntegerType();
    public static final DataType LONG = new LongType();
    public static final DataType ID = new IdType();
    public static final DataType DOUBLE = new DoubleType();
    public static final DataType FLOAT = new FloatType();
    public static final DataType BYTE = new ByteType();
    public static final DataType DURATION = new DurationType();
    public static final DataType PERCENT = new PercentType();
    public static final ListType LIST = new ListType();
    public static final HashSetType SET = new HashSetType();
    public static final DataType ENUM = new EnumType();
    public static final DataType DATE = new DateType();
    public static final DataType TIME = new TimeType();
    public static final DataType STRING = new StringType();
    public static final DataType BLOB = new BlobType();
    public static final DataType CLOB = new ClobType();
    public static final DataType DATASIZE = new DataSizeType();
    public static final DataType BLOCK = new BlockType();
    public static final DataType CHANGEID = new ChangesetIdType();
    public static final DataType BUILD = new BuildType();
    public static final DataType LEVEL = new LevelType();
    public static final DataType TEST_STATUS = new TestStatusType();
    public static final DataType OBJECT = new ObjectType();
    public static final ListType LIST_LONG = new ListType(LONG);
    public static final ListType LIST_DOUBLE = new ListType(DOUBLE);
    private static Map<String, DataType> TYPES;

    public static DataType getDataType(String type) {
        DataType dataType = TYPES.get(type);
        if (dataType != null) {
            return dataType;
        }
        if ("OBJECT".equalsIgnoreCase(type)) {
            return OBJECT;
        }
        List extensions = ((PluginManager)Quickbuild.getInstance(PluginManager.class)).getExtensions(DataType.class);
        for (DataType each : extensions) {
            if (!each.getType().equalsIgnoreCase(type)) continue;
            return each;
        }
        throw new UnknownTypeException(type, DataType.class);
    }

    private static DataType getPrimitiveDataType(Class<?> clazz) {
        if (clazz == Integer.TYPE || clazz == Short.TYPE) {
            return INTEGER;
        }
        if (clazz == Long.TYPE) {
            return LONG;
        }
        if (clazz == Double.TYPE) {
            return DOUBLE;
        }
        if (clazz == Float.TYPE) {
            return DOUBLE;
        }
        if (clazz == Boolean.TYPE) {
            return BOOLEAN;
        }
        if (clazz == Character.TYPE) {
            return INTEGER;
        }
        throw new UnknownTypeException(clazz.getName(), DataType.class);
    }

    public static DataType getDataType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return DataTypes.getPrimitiveDataType(clazz);
        }
        for (DataType each : TYPES.values()) {
            if (!each.getReturnedClass().isAssignableFrom(clazz)) continue;
            return each;
        }
        if (Quickbuild.getInstance() == null) {
            return OBJECT;
        }
        List extensions = ((PluginManager)Quickbuild.getInstance(PluginManager.class)).getExtensions(DataType.class);
        for (DataType each : extensions) {
            if (!each.getReturnedClass().isAssignableFrom(clazz)) continue;
            return each;
        }
        return OBJECT;
    }

    public static DataType getDataType(Object value) {
        Preconditions.checkNotNull((Object)value, (Object)"Looking for DataType for a null value is disabled.");
        return DataTypes.getDataType(value.getClass());
    }

    public static DataType createDataType(String typeName) {
        DataType dataType = DataTypes.getDataType(typeName);
        return dataType.newInstance();
    }

    public static boolean isSameType(DataType type1, DataType type2) {
        return type1.getType().equalsIgnoreCase(type2.getType());
    }

    public static DataType createDataType(Element node) {
        String type = XMLHelper.getString((Node)node, "dataType");
        String className = XMLHelper.getString((Node)node, "dataTypeClass");
        DataType dataType = null;
        if (!Strings.isNullOrEmpty((String)className)) {
            dataType = TypedObjects.instantiateClass(className, DataType.class);
        } else if (!Strings.isNullOrEmpty((String)type)) {
            dataType = DataTypes.createDataType(type);
        } else {
            throw new ParseException("No dataType defined for element [\n" + node.asXML() + "].");
        }
        dataType.fromXML(node);
        return dataType;
    }

    static {
        TypedObjectMap<DataType> types = new TypedObjectMap<DataType>();
        types.add(STRING);
        types.add(BLOB);
        types.add(BOOLEAN);
        types.add(INTEGER);
        types.add(LONG);
        types.add(ID);
        types.add(DOUBLE);
        types.add(FLOAT);
        types.add(BYTE);
        types.add(DURATION);
        types.add(PERCENT);
        types.add(LIST);
        types.add(SET);
        types.add(ENUM);
        types.add(DATE);
        types.add(TIME);
        types.add(CLOB);
        types.add(BLOB);
        types.add(DATASIZE);
        types.add(CHANGEID);
        types.add(BLOCK);
        types.add(TEST_STATUS);
        types.add(LEVEL);
        types.add(BUILD);
        TYPES = types.getMap();
    }
}

