/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datatype;

import com.google.common.io.CharStreams;
import com.pmease.quickbuild.plugin.report.engine.annotation.NodeType;
import com.pmease.quickbuild.plugin.report.engine.datatype.StringType;
import com.pmease.quickbuild.plugin.report.engine.exception.DatabaseException;
import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialException;
import org.apache.commons.io.IOUtils;

public class ClobType
extends StringType {
    public ClobType() {
        this.nodeType = NodeType.CDATA;
    }

    @Override
    public String getType() {
        return "CLOB";
    }

    @Override
    public String getSqlType() {
        return "CLOB";
    }

    @Override
    public Object asDbObject(Object original) {
        if (original == null) {
            return null;
        }
        if (original instanceof Clob) {
            return original;
        }
        String str = (String)this.typeCast(original);
        try {
            return new SerialClob(str.toCharArray());
        }
        catch (SerialException e) {
            throw new DatabaseException(String.format("Unable to convert object [%s] to clob" + original, new Object[0]), e);
        }
        catch (SQLException e) {
            throw new DatabaseException(String.format("Unable to convert object [%s] to clob" + original, new Object[0]), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object fromDbObject(ResultSet rs, String columnName) {
        try {
            Clob clob = rs.getClob(columnName);
            if (clob == null) {
                return null;
            }
            Reader reader = clob.getCharacterStream();
            try {
                String string = CharStreams.toString((Readable)reader);
                return string;
            }
            catch (IOException e) {
                throw new DatabaseException("Retrieve column " + columnName + " with data type " + this + " failed.", e);
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
        }
        catch (SQLException e) {
            throw new DatabaseException("Retrieve column " + columnName + " with data type " + this + " failed.", e);
        }
    }
}

