/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datatype;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.datatype.ChangesetId;
import com.pmease.quickbuild.plugin.report.engine.datatype.ObjectType;
import com.pmease.quickbuild.plugin.report.engine.exception.DatabaseException;
import com.pmease.quickbuild.plugin.report.engine.exception.TypeCastException;
import com.pmease.quickbuild.plugin.report.engine.util.csv.CSVParser;
import com.pmease.quickbuild.plugin.report.engine.util.csv.CSVWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.wicket.util.io.IOUtils;

public class ChangesetIdType
extends ObjectType {
    private static final long serialVersionUID = 1L;

    @Override
    public String getType() {
        return "CHANGEID";
    }

    @Override
    public Object fromString(String str, String pattern, Locale locale) {
        if (Strings.isNullOrEmpty((String)str)) {
            return null;
        }
        String[] tokens = new CSVParser(':').parse(str);
        ChangesetId id = new ChangesetId();
        id.setChangeId(tokens[0]);
        id.setRepository(tokens[1]);
        return id;
    }

    @Override
    public String asString(Object value, String pattern, Locale locale) {
        ChangesetId id = this.typeCast(value);
        if (id == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        CSVWriter writer = new CSVWriter(sw, ':');
        ArrayList list = Lists.newArrayListWithCapacity((int)2);
        if (id.getChangeId() == null) {
            list.add("");
        } else {
            list.add(id.getChangeId());
        }
        if (id.getRepository() == null) {
            list.add("");
        } else {
            list.add(id.getRepository());
        }
        try {
            writer.join(list);
            String string = sw.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)sw);
        }
    }

    @Override
    public ChangesetId typeCast(Object from) {
        if (from == null) {
            return null;
        }
        if (from instanceof ChangesetId) {
            return (ChangesetId)from;
        }
        if (from instanceof String) {
            return (ChangesetId)this.fromString((String)from);
        }
        throw new TypeCastException(from, this);
    }

    @Override
    public ChangesetId getDefaultValue() {
        return new ChangesetId();
    }

    @Override
    public String getDefaultPattern() {
        return null;
    }

    @Override
    public Class<?> getReturnedClass() {
        return ChangesetId.class;
    }

    @Override
    public String getSqlType() {
        return "VARCHAR";
    }

    @Override
    public Object asDbObject(Object original) {
        return this.asString(original);
    }

    @Override
    public Object fromDbObject(ResultSet rs, String columnName) {
        try {
            String str = rs.getString(columnName);
            return this.fromString(str);
        }
        catch (SQLException e) {
            throw new DatabaseException("Retrieve column " + columnName + " with data type " + this + " failed.", e);
        }
    }
}

