/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datatype;

import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.report.engine.datatype.AbstractNumericType;
import com.pmease.quickbuild.plugin.report.engine.exception.DatabaseException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.commons.validator.routines.ByteValidator;

public class ByteType
extends AbstractNumericType {
    private static final long serialVersionUID = 1L;

    @Override
    public Byte typeCast(Object from) {
        Number number = this.toNumber(from);
        if (number == null) {
            return null;
        }
        return number.byteValue();
    }

    @Override
    public Object fromString(String str, String pattern, Locale locale) {
        if (Strings.isNullOrEmpty((String)str)) {
            return null;
        }
        if (Strings.isNullOrEmpty((String)pattern)) {
            return Byte.valueOf(str);
        }
        return ByteValidator.getInstance().validate(str, pattern, locale);
    }

    @Override
    public String asString(Object value, String pattern, Locale locale) {
        Byte b = this.typeCast(value);
        if (b == null) {
            return null;
        }
        return ByteValidator.getInstance().format((Object)b, pattern, locale);
    }

    @Override
    public Byte getDefaultValue() {
        return (byte)0;
    }

    @Override
    public String getDefaultPattern() {
        return null;
    }

    @Override
    public Class<?> getReturnedClass() {
        return Byte.class;
    }

    @Override
    public String getSqlType() {
        return "SMALLINT";
    }

    @Override
    public String getType() {
        return "BYTE";
    }

    @Override
    public Object fromDbObject(ResultSet rs, String columnName) {
        try {
            return rs.getByte(columnName);
        }
        catch (SQLException e) {
            throw new DatabaseException("Retrieve column " + columnName + " with data type " + this + " failed.", e);
        }
    }
}

