/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datatype;

import com.google.common.base.Strings;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.datatype.ObjectType;
import com.pmease.quickbuild.plugin.report.engine.exception.TypeCastException;
import com.pmease.quickbuild.plugin.report.engine.util.BuildFragment;
import com.pmease.quickbuild.plugin.report.engine.util.csv.CSVHelper;
import java.util.Locale;

public class BuildType
extends ObjectType {
    private static final long serialVersionUID = 1L;

    @Override
    public String getType() {
        return "BUILD";
    }

    @Override
    public Class<?> getReturnedClass() {
        return BuildFragment.class;
    }

    @Override
    public BuildFragment typeCast(Object from) {
        if (from == null) {
            return null;
        }
        if (from instanceof BuildFragment) {
            return (BuildFragment)from;
        }
        if (from instanceof Build) {
            return new BuildFragment((Build)from);
        }
        if (from instanceof String) {
            return (BuildFragment)this.fromString((String)from);
        }
        throw new TypeCastException(from, this);
    }

    @Override
    public Object fromString(String str, String pattern, Locale locale) {
        if (Strings.isNullOrEmpty((String)str)) {
            return null;
        }
        if ("XML".equalsIgnoreCase(pattern)) {
            return VersionedDocument.xstream.fromXML(str);
        }
        return CSVHelper.fromString(str, new BuildFragment(), BuildFragment.ATTRIBUTES);
    }

    @Override
    public String asString(Object value, String pattern, Locale locale) {
        BuildFragment build = this.typeCast(value);
        if (build == null) {
            return null;
        }
        if ("XML".equalsIgnoreCase(pattern)) {
            return VersionedDocument.xstream.toXML((Object)build);
        }
        return CSVHelper.asString(value, BuildFragment.ATTRIBUTES);
    }
}

