/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datatype;

import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.report.engine.datatype.AbstractDataType;
import com.pmease.quickbuild.plugin.report.engine.exception.DatabaseException;
import com.pmease.quickbuild.plugin.report.engine.exception.ParseException;
import com.pmease.quickbuild.plugin.report.engine.exception.TypeCastException;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class BooleanType
extends AbstractDataType {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean isPrimitiveType() {
        return true;
    }

    @Override
    public Object getDefaultValue() {
        return Boolean.FALSE;
    }

    @Override
    public Class<?> getReturnedClass() {
        return Boolean.class;
    }

    @Override
    public Boolean typeCast(Object from) {
        if (from == null) {
            return null;
        }
        if (from instanceof Boolean) {
            return (Boolean)from;
        }
        if (from instanceof Number) {
            return ((Number)from).intValue() > 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (from instanceof String) {
            if ("true".equalsIgnoreCase((String)from)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase((String)from)) {
                return Boolean.FALSE;
            }
        }
        throw new TypeCastException(from, this);
    }

    public Number toNumber(Object value) {
        if (value == null) {
            return null;
        }
        Boolean b = this.typeCast(value);
        return b != false ? 1 : 0;
    }

    @Override
    public Object fromString(String str, String pattern, Locale locale) {
        if (Strings.isNullOrEmpty((String)str)) {
            return null;
        }
        if (str.equalsIgnoreCase("true") || str.equalsIgnoreCase("false")) {
            return new Boolean(str.toLowerCase());
        }
        try {
            BigDecimal number = new BigDecimal(str);
            if (number != null) {
                return ((Number)number).intValue() > 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        String[] tokens = StringUtils.split((String)pattern);
        if (tokens.length != 2) {
            throw new ParseException("The pattern for BooleanType should be True:False format.");
        }
        if (str.equalsIgnoreCase(tokens[0])) {
            return Boolean.TRUE;
        }
        if (str.equalsIgnoreCase(tokens[1])) {
            return Boolean.FALSE;
        }
        throw new TypeCastException((Object)str, this);
    }

    @Override
    public String asString(Object value, String pattern, Locale locale) {
        Boolean b = this.typeCast(value);
        if (b == null) {
            return null;
        }
        if (pattern == null) {
            return b.toString();
        }
        String[] tokens = StringUtils.split((String)pattern, (String)":");
        if (tokens.length != 2) {
            throw new ParseException("The pattern for BooleanType should be True:False format.");
        }
        return b != false ? tokens[0] : tokens[1];
    }

    @Override
    public String getDefaultPattern() {
        return null;
    }

    @Override
    public Object asDbObject(Object original) {
        Object b = this.typeCast(original);
        if (b == null) {
            b = this.getDefaultValue();
        }
        return b;
    }

    public Object fromDbObject(Object original) {
        return this.typeCast(original);
    }

    @Override
    public String getType() {
        return "BOOLEAN";
    }

    @Override
    public String getSqlType() {
        return "BOOLEAN";
    }

    @Override
    public Object fromDbObject(ResultSet rs, String columnName) {
        try {
            return rs.getBoolean(columnName);
        }
        catch (SQLException e) {
            throw new DatabaseException("Retrieve column " + columnName + " with data type " + this + " failed.", e);
        }
    }
}

