/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datatype;

import com.google.common.base.Strings;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.plugin.report.engine.annotation.NodeType;
import com.pmease.quickbuild.plugin.report.engine.datatype.ObjectType;
import com.pmease.quickbuild.plugin.report.engine.exception.TypeCastException;
import com.pmease.quickbuild.plugin.report.engine.util.csv.CSVParser;
import com.pmease.quickbuild.plugin.report.engine.util.csv.CSVWriter;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.web.page.source.Block;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.io.IOUtils;

public class BlockType
extends ObjectType {
    private static final long serialVersionUID = 1L;
    public static final String ESCAPE_LF = "&#qbcr;";

    public BlockType() {
        this.nodeType = NodeType.CDATA;
    }

    @Override
    protected String getReadFormat() {
        return null;
    }

    @Override
    public Object fromString(String str, String pattern, Locale locale) {
        if (Strings.isNullOrEmpty((String)str)) {
            return null;
        }
        if ("XML".equalsIgnoreCase(pattern)) {
            return VersionedDocument.xstream.fromXML(str);
        }
        try {
            String[] tokens = new CSVParser(':').parse(str);
            Block block = this.getDefaultValue();
            block.setStartLine(Integer.valueOf(tokens[0]).intValue());
            block.setEndLine(Integer.valueOf(tokens[1]).intValue());
            block.setColor(tokens[2]);
            block.setMessage(tokens[3]);
            return block;
        }
        catch (Exception e) {
            throw new TypeCastException((Object)str, this);
        }
    }

    @Override
    public String asString(Object value, String pattern, Locale locale) {
        Block block = this.typeCast(value);
        if (block == null) {
            return null;
        }
        if ("XML".equalsIgnoreCase(pattern)) {
            return VersionedDocument.xstream.toXML((Object)block);
        }
        StringWriter sw = new StringWriter();
        CSVWriter writer = new CSVWriter(sw, ':');
        try {
            ArrayList<String> str = new ArrayList<String>();
            str.add(String.valueOf(block.getStartLine()));
            str.add(String.valueOf(block.getEndLine()));
            if (block.getColor() == null) {
                str.add("");
            } else {
                str.add(block.getColor());
            }
            if (block.getMessage() == null) {
                str.add("");
            } else {
                str.add(block.getMessage());
            }
            writer.join(str);
            String string = sw.toString();
            return string;
        }
        catch (IOException e) {
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)sw);
        }
    }

    public Block typeCast(Object from) {
        if (from == null) {
            return null;
        }
        if (from instanceof Block) {
            return (Block)from;
        }
        if (from instanceof String) {
            return (Block)this.fromString((String)from);
        }
        throw new TypeCastException(from, this);
    }

    @Override
    public String getDefaultPattern() {
        return null;
    }

    @Override
    public Class<?> getReturnedClass() {
        return Block.class;
    }

    public Block getDefaultValue() {
        return new Block();
    }

    @Override
    public Object asDbObject(Object original) {
        return this.asString(original, null);
    }

    @Override
    public Object fromDbObject(Object original) {
        return this.fromString((String)original, null);
    }

    @Override
    public String getType() {
        return "BLOCK";
    }
}

