/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datatype;

import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.datatype.AbstractDataType;
import com.pmease.quickbuild.plugin.report.engine.exception.TypeCastException;
import com.pmease.quickbuild.plugin.report.engine.util.XMLHelper;
import java.math.BigDecimal;
import java.util.Locale;
import org.apache.commons.validator.routines.BigDecimalValidator;
import org.dom4j.Element;
import org.dom4j.Node;

public abstract class AbstractNumericType
extends AbstractDataType {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean isNumericType() {
        return true;
    }

    @Override
    public boolean isPrimitiveType() {
        return true;
    }

    @Override
    public Object asDbObject(Object original) {
        Object obj = this.typeCast(original);
        if (obj == null) {
            obj = this.getDefaultValue();
        }
        return obj;
    }

    @Override
    public Object readFromNode(Element node, String nodeName, Locale locale) {
        String str = XMLHelper.getString((Node)node, nodeName);
        if (Strings.isNullOrEmpty((String)str)) {
            return null;
        }
        if ("NaN".equalsIgnoreCase(str)) {
            return 0;
        }
        BigDecimal decimal = new BigDecimal(str);
        return this.typeCast(decimal);
    }

    @Override
    public void writeToNode(Element parentNode, String nodeName, Object value, Locale locale) {
        if (value == null) {
            return;
        }
        String str = value.toString();
        if (!Strings.isNullOrEmpty((String)str)) {
            switch (this.nodeType) {
                case ATTRIBUTE: {
                    parentNode.addAttribute(nodeName, str);
                    break;
                }
                case ELEMENT: {
                    Element e1 = parentNode.addElement(nodeName);
                    e1.setText(str);
                    break;
                }
                case CDATA: {
                    Element e2 = parentNode.addElement(nodeName);
                    e2.addCDATA(str);
                }
            }
        }
    }

    public Number toNumber(Object other) {
        if (other == null) {
            return null;
        }
        if (other instanceof Number) {
            return (Number)other;
        }
        if (other instanceof String) {
            if ("NaN".equalsIgnoreCase((String)other)) {
                return 0;
            }
            return BigDecimalValidator.getInstance().validate((String)other, ReportHelper.getLocale());
        }
        if (other instanceof Boolean) {
            return (Boolean)other != false ? 1 : 0;
        }
        throw new TypeCastException(other, this);
    }
}

