/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datatype;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.annotation.NodeType;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import com.pmease.quickbuild.plugin.report.engine.util.XMLHelper;
import com.pmease.quickbuild.util.ClassUtils;
import java.util.Locale;
import org.apache.commons.collections.comparators.ComparableComparator;
import org.dom4j.Element;
import org.dom4j.Node;

public abstract class AbstractDataType
implements DataType {
    private static final long serialVersionUID = 1L;
    protected NodeType nodeType = NodeType.ATTRIBUTE;
    public static final String XML_FORMAT = "XML";
    public static final String CSV_FORMAT = "CSV";

    protected AbstractDataType() {
    }

    protected AbstractDataType(NodeType nodeType) {
        this.nodeType = nodeType;
    }

    @Override
    public Object fromString(String str) {
        return this.fromString(str, this.getDefaultPattern());
    }

    @Override
    public Object fromString(String str, String pattern) {
        return this.fromString(str, pattern, ReportHelper.getLocale());
    }

    @Override
    public String asString(Object value) {
        return this.asString(value, this.getDefaultPattern());
    }

    @Override
    public String asString(Object value, String pattern) {
        return this.asString(value, pattern, ReportHelper.getLocale());
    }

    @Override
    public Object getDefaultValue() {
        return null;
    }

    @Override
    public boolean isEqual(Object x, Object y) {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        Object value1 = this.typeCast(x);
        Object value2 = this.typeCast(y);
        return Objects.equal((Object)value1, (Object)value2);
    }

    @Override
    public int compare(Object x, Object y) {
        if (x == null && y == null) {
            return 0;
        }
        if (x == null) {
            return -1;
        }
        if (y == null) {
            return 1;
        }
        return ComparableComparator.getInstance().compare(x, y);
    }

    @Override
    public boolean isNumericType() {
        return false;
    }

    @Override
    public boolean isCollectionType() {
        return false;
    }

    @Override
    public boolean isIdType() {
        return false;
    }

    @Override
    public boolean isPrimitiveType() {
        return false;
    }

    @Override
    public DataType newInstance() {
        AbstractDataType instance = (AbstractDataType)ClassUtils.instantiateClass(this.getClass(), (Object[])new Object[0]);
        instance.nodeType = this.nodeType;
        return instance;
    }

    @Override
    public void fromXML(Element node) {
        String t = XMLHelper.getString((Node)node, "nodeType");
        if (!Strings.isNullOrEmpty((String)t)) {
            this.nodeType = NodeType.valueOf(t.toUpperCase());
        }
    }

    @Override
    public void toXML(Element node) {
        node.addAttribute("dataType", this.getType());
        if (this.nodeType != NodeType.ATTRIBUTE) {
            node.addAttribute("nodeType", this.nodeType.name());
        }
    }

    @Override
    public NodeType getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(NodeType nodeType) {
        this.nodeType = nodeType;
    }

    protected String getReadFormat() {
        return null;
    }

    protected String getWriteFormat() {
        return null;
    }

    @Override
    public Object readFromNode(Element node, String nodeName, Locale locale) {
        String str = XMLHelper.getString((Node)node, nodeName);
        return this.fromString(str, this.getReadFormat(), locale);
    }

    @Override
    public void writeToNode(Element parentNode, String nodeName, Object value, Locale locale) {
        String str = this.asString(value, this.getWriteFormat(), locale);
        if (!Strings.isNullOrEmpty((String)str)) {
            switch (this.nodeType) {
                case ATTRIBUTE: {
                    parentNode.addAttribute(nodeName, str);
                    break;
                }
                case ELEMENT: {
                    Element e1 = parentNode.addElement(nodeName);
                    e1.setText(str);
                    break;
                }
                case CDATA: {
                    Element e2 = parentNode.addElement(nodeName);
                    e2.addCDATA(this.escapeCDATA(str));
                }
            }
        }
    }

    private String escapeCDATA(String str) {
        return str.replaceAll("]]>", "]]]]><![CDATA[>");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof DataType)) {
            return false;
        }
        DataType rhs = (DataType)other;
        return this.getType().equalsIgnoreCase(rhs.getType());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getType()});
    }

    public String toString() {
        return this.getType();
    }
}

