/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datatype;

import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.report.engine.annotation.NodeType;
import com.pmease.quickbuild.plugin.report.engine.datatype.AbstractDataType;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.datatype.StringType;
import com.pmease.quickbuild.plugin.report.engine.exception.DatabaseException;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import com.pmease.quickbuild.plugin.report.engine.util.TypedObjects;
import com.pmease.quickbuild.plugin.report.engine.util.XMLHelper;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import org.apache.wicket.util.lang.Objects;
import org.dom4j.Element;
import org.dom4j.Node;

public abstract class AbstractCollectionType
extends AbstractDataType {
    private static final long serialVersionUID = 1L;
    protected DataType itemType;
    protected char delimiter = (char)44;

    public abstract String asString(Object var1, String var2, String var3, Locale var4);

    public abstract Object fromString(String var1, String var2, String var3, Locale var4);

    public AbstractCollectionType() {
        this.itemType = new StringType();
        this.nodeType = NodeType.ELEMENT;
    }

    public AbstractCollectionType(DataType itemType) {
        this.itemType = itemType;
        this.nodeType = itemType.getNodeType() == NodeType.CDATA ? NodeType.CDATA : NodeType.ELEMENT;
    }

    @Override
    public Object readFromNode(Element node, String nodeName, Locale locale) {
        String str = XMLHelper.getString((Node)node, nodeName);
        return this.fromString(str, this.getReadFormat(), ((AbstractDataType)this.itemType).getReadFormat(), locale);
    }

    @Override
    public void writeToNode(Element parentNode, String nodeName, Object value, Locale locale) {
        String str = this.asString(value, this.getWriteFormat(), ((AbstractDataType)this.itemType).getWriteFormat(), locale);
        if (!Strings.isNullOrEmpty((String)str)) {
            switch (this.nodeType) {
                case ATTRIBUTE: {
                    parentNode.addAttribute(nodeName, str);
                    break;
                }
                case ELEMENT: {
                    Element e1 = parentNode.addElement(nodeName);
                    e1.setText(str);
                    break;
                }
                case CDATA: {
                    Element e2 = parentNode.addElement(nodeName);
                    e2.addCDATA(str);
                }
            }
        }
    }

    @Override
    public void fromXML(Element node) {
        Element e;
        super.fromXML(node);
        String s = XMLHelper.getString((Node)node, "delimiter");
        if (!Strings.isNullOrEmpty((String)s)) {
            this.delimiter = s.charAt(0);
        }
        this.itemType = (e = node.element("itemType")) != null ? this.createItemType(e) : this.createItemType(node);
        this.nodeType = this.itemType.getNodeType() == NodeType.CDATA ? NodeType.CDATA : NodeType.ELEMENT;
    }

    private DataType createItemType(Element node) {
        String type = XMLHelper.getString((Node)node, "itemType");
        String className = XMLHelper.getString((Node)node, "itemTypeClass");
        DataType dataType = null;
        dataType = !Strings.isNullOrEmpty((String)className) ? TypedObjects.instantiateClass(className, DataType.class) : (!Strings.isNullOrEmpty((String)type) ? DataTypes.createDataType(type) : new StringType());
        dataType.fromXML(node);
        return dataType;
    }

    @Override
    public int compare(Object x, Object y) {
        if (x == y || x == null && y == null) {
            return 0;
        }
        if (x == null) {
            return -1;
        }
        if (y == null) {
            return 1;
        }
        Collection c1 = (Collection)x;
        Collection c2 = (Collection)y;
        Iterator it1 = c1.iterator();
        Iterator it2 = c2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            Object value2;
            Object value1 = it1.next();
            int i = this.itemType.compare(value1, value2 = it2.next());
            if (i == 0) continue;
            return i;
        }
        if (it1.hasNext()) {
            return 1;
        }
        if (it2.hasNext()) {
            return -1;
        }
        return 0;
    }

    @Override
    public void toXML(Element parent) {
        super.toXML(parent);
        Element e = parent.addElement("itemType");
        this.itemType.toXML(e);
    }

    @Override
    public Object fromString(String str, String pattern, Locale locale) {
        if (Strings.isNullOrEmpty((String)pattern)) {
            return this.fromString(str, null, null, locale);
        }
        return this.fromString(str, pattern, this.itemType.getDefaultPattern(), locale);
    }

    @Override
    public String asString(Object value, String pattern, Locale locale) {
        if (Strings.isNullOrEmpty((String)pattern)) {
            return this.asString(value, null, null, locale);
        }
        return this.asString(value, pattern, this.itemType.getDefaultPattern(), locale);
    }

    @Override
    public boolean isCollectionType() {
        return true;
    }

    @Override
    public String getSqlType() {
        return "VARCHAR";
    }

    @Override
    public Object asDbObject(Object original) {
        Collection c = (Collection)this.typeCast(original);
        if (c == null || c.isEmpty()) {
            return null;
        }
        return this.asString(c, null);
    }

    @Override
    public Object fromDbObject(ResultSet rs, String columnName) {
        try {
            String str = rs.getString(columnName);
            return this.fromString(str, null);
        }
        catch (SQLException e) {
            throw new DatabaseException("Retrieve column " + columnName + " with data type " + this + " failed.", e);
        }
    }

    public DataType getItemType() {
        return this.itemType;
    }

    public void setItemType(DataType itemType) {
        this.itemType = itemType;
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        AbstractCollectionType rhs = (AbstractCollectionType)other;
        return this.itemType.equals(rhs.itemType);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getType(), this.itemType.getType()});
    }
}

