/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datastore.filter;

import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.FilterDef;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Funcs;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.SimpleExpression;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.AbstractTypedXMLObject;
import java.util.Map;

public class SimpleFilterDef
extends AbstractTypedXMLObject
implements FilterDef {
    private static final long serialVersionUID = 1L;
    @Alias
    private String column;
    @Alias
    private String op = "=";
    @Alias
    private String value;
    @Alias
    private boolean needEvaluate = true;

    public SimpleFilterDef() {
    }

    public SimpleFilterDef(String column, String value) {
        this.column = column;
        this.value = value;
        this.needEvaluate = true;
    }

    @Override
    public String getType() {
        return "DEFAULT";
    }

    @Override
    public SimpleExpression toFilter() {
        return new SimpleExpression(this.column, Funcs.AnyFunc.fromSqlOp(this.op), this.value);
    }

    @Override
    public SimpleExpression toFilter(Map<String, Object> context) {
        if (!this.needEvaluate || context == null) {
            return this.toFilter();
        }
        ScriptEngine se = (ScriptEngine)Quickbuild.getInstance(ScriptEngine.class);
        Object obj = se.evaluate(this.value, context);
        return new SimpleExpression(this.column, Funcs.AnyFunc.fromSqlOp(this.op), obj);
    }

    @Override
    public String getElementName() {
        return "filter";
    }

    @Override
    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public String getOp() {
        return this.op;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public boolean isNeedEvaluate() {
        return this.needEvaluate;
    }

    public void setNeedEvaluate(boolean needEvaluate) {
        this.needEvaluate = needEvaluate;
    }
}

