/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datastore.filter;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Connective;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.FilterPriority;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Func;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Funcs;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.IncExc;

public class SearchCriterion
implements Filter {
    private static final long serialVersionUID = 1L;
    private String columnName;
    private String displayName;
    private Func op;
    private Object value;
    private Connective connective = Connective.AND;
    private IncExc include = IncExc.include;

    public SearchCriterion() {
    }

    public SearchCriterion(SearchCriterion other) {
        if (other != null) {
            this.columnName = other.columnName;
            this.displayName = other.displayName;
            this.op = other.op;
            this.value = other.value;
            this.connective = other.connective;
            this.include = other.include;
        }
    }

    public SearchCriterion(String columnName, Func op, Object value) {
        this.columnName = columnName;
        this.op = op;
        this.value = value;
    }

    public boolean isValid() {
        return !Strings.isNullOrEmpty((String)this.columnName) && this.op != null && this.value != null;
    }

    @Override
    public String toSqlString() {
        Preconditions.checkArgument((boolean)this.isValid());
        StringBuffer sb = new StringBuffer();
        if (this.getOp() instanceof Funcs.StringFunc) {
            if (this.getOp() == Funcs.StringFunc.EQUAL) {
                sb.append(this.getColumnName());
            } else {
                sb.append("LOWER(" + this.getColumnName() + ")");
            }
        } else {
            sb.append(this.getColumnName());
        }
        sb.append(" ").append(this.getOp().getSqlOp()).append(" ").append("?");
        if (this.getInclude() == IncExc.exclude) {
            return "not (" + sb.toString() + ")";
        }
        return sb.toString();
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getDisplayName() {
        if (Strings.isNullOrEmpty((String)this.displayName)) {
            return this.columnName;
        }
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Func getOp() {
        return this.op;
    }

    public void setOp(Func op) {
        this.op = op;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getActualValue() {
        if (this.getOp() instanceof Funcs.StringFunc) {
            Funcs.StringFunc f = (Funcs.StringFunc)this.getOp();
            switch (f) {
                case START_WITH: {
                    return (this.value + "%").toLowerCase();
                }
                case END_WITH: {
                    return ("%" + this.value).toLowerCase();
                }
                case CONTAINING: {
                    return ("%" + this.value + "%").toLowerCase();
                }
                case EQUAL: {
                    return this.value.toString();
                }
            }
            return this.value.toString().toLowerCase();
        }
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Connective getConnective() {
        return this.connective;
    }

    public void setConnective(Connective connective) {
        this.connective = connective;
    }

    public IncExc getInclude() {
        return this.include;
    }

    public void setInclude(IncExc include) {
        this.include = include;
    }

    public SearchCriterion clone() {
        return new SearchCriterion(this);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof SearchCriterion)) {
            return false;
        }
        SearchCriterion rhs = (SearchCriterion)other;
        return Objects.equal((Object)this.columnName, (Object)rhs.columnName) && Objects.equal((Object)this.op, (Object)rhs.op) && Objects.equal((Object)this.value, (Object)rhs.value) && Objects.equal((Object)((Object)this.include), (Object)((Object)rhs.include));
    }

    public int hashcode() {
        return Objects.hashCode((Object[])new Object[]{this.columnName, this.op, this.value, this.include});
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDisplayName()).append(" ").append(this.op.getDisplayName()).append(" [").append(this.value).append("]");
        if (this.getInclude() == IncExc.exclude) {
            return "excluding (" + sb.toString() + ")";
        }
        return sb.toString();
    }

    @Override
    public Object[] getParams() {
        return new Object[]{this.getActualValue()};
    }

    @Override
    public String[] getColumns() {
        return new String[]{this.getColumnName()};
    }

    @Override
    public String toBreadcrumb() {
        return this.toString();
    }

    @Override
    public FilterPriority getPriority() {
        return FilterPriority.MEDIUM;
    }
}

