/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datastore.filter;

import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Connective;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Funcs;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.LogicExpression;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.NotExpression;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.SearchCriterion;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.SimpleExpression;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.SqlClauseFilter;
import org.hibernate.criterion.MatchMode;

public class Restrictions {
    private Restrictions() {
    }

    public static SearchCriterion idEq(Long id) {
        return new SimpleExpression("ID", Funcs.NumberFunc.EQUAL, id);
    }

    public static SearchCriterion eq(String columnName, Object value) {
        return new SimpleExpression(columnName, Funcs.AnyFunc.EQUAL, value);
    }

    public static SearchCriterion lt(String columnName, Object value) {
        return new SimpleExpression(columnName, Funcs.AnyFunc.LESS_THAN, value);
    }

    public static SearchCriterion le(String columnName, Object value) {
        return new SimpleExpression(columnName, Funcs.AnyFunc.LESS_EQUAL_THAN, value);
    }

    public static SearchCriterion gt(String columnName, Object value) {
        return new SimpleExpression(columnName, Funcs.AnyFunc.GREATER_THAN, value);
    }

    public static SearchCriterion ge(String columnName, Object value) {
        return new SimpleExpression(columnName, Funcs.AnyFunc.GREATER_EQUAL_THAN, value);
    }

    public static SearchCriterion like(String column, String pattern) {
        return new SearchCriterion(column, Funcs.StringFunc.CONTAINING, pattern);
    }

    public static SearchCriterion like(String column, String pattern, MatchMode mode) {
        if (mode == MatchMode.START) {
            return new SearchCriterion(column, Funcs.StringFunc.START_WITH, pattern);
        }
        if (mode == MatchMode.END) {
            return new SearchCriterion(column, Funcs.StringFunc.END_WITH, pattern);
        }
        if (mode == MatchMode.EXACT) {
            return new SearchCriterion(column, Funcs.StringFunc.EQUAL, pattern);
        }
        return new SearchCriterion(column, Funcs.StringFunc.CONTAINING, pattern);
    }

    public static Filter and(Filter lhs, Filter rhs) {
        return new LogicExpression(lhs, Connective.AND, rhs);
    }

    public static Filter or(Filter lhs, Filter rhs) {
        return new LogicExpression(lhs, Connective.OR, rhs);
    }

    public static Filter not(Filter lhs) {
        return new NotExpression(lhs);
    }

    public static Filter directSql(String clause) {
        return new SqlClauseFilter(clause);
    }
}

