/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datastore.filter;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.CompositeFilter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.ContainsFilter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.SearchCriterion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class ReportFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<SearchCriterion> simpleFilters = Lists.newArrayList();
    private ContainsFilter containsFilter;
    private CompositeFilter advancedFilter;

    public ReportFilter() {
    }

    public ReportFilter(ReportFilter other) {
        if (other != null) {
            if (other.containsFilter != null) {
                this.setContainsFilter(new ContainsFilter(other.containsFilter));
            }
            if (other.advancedFilter != null) {
                this.setAdvancedFilter(new CompositeFilter(other.advancedFilter));
            }
            this.simpleFilters.addAll(other.simpleFilters);
        }
    }

    public boolean contains(String columnName) {
        Set<String> set = this.getAllColumnNames();
        return ReportHelper.ignoreCaseContains(set, columnName);
    }

    public void remove(String columnName) {
        this.removeSimpleFilter(columnName);
        if (this.hasContainsFilter()) {
            this.containsFilter.remove(columnName);
        }
        if (this.hasAdvancedFilter()) {
            this.advancedFilter.remove(columnName);
        }
    }

    public void removeSimpleFilter(String columnName) {
        Iterator<SearchCriterion> it = this.simpleFilters.iterator();
        while (it.hasNext()) {
            SearchCriterion each = it.next();
            if (!each.getColumnName().equalsIgnoreCase(columnName)) continue;
            it.remove();
        }
    }

    public boolean hasContainsFilter() {
        return this.containsFilter != null && !Strings.isNullOrEmpty((String)this.containsFilter.getPattern());
    }

    public boolean hasAdvancedFilter() {
        return this.advancedFilter != null && this.advancedFilter.size() > 0;
    }

    public void clear() {
        this.simpleFilters = Lists.newArrayList();
        this.setContainsFilter(null);
        this.setAdvancedFilter(null);
    }

    public void addSimpleFilter(SearchCriterion crit) {
        if (crit == null) {
            return;
        }
        this.removeSimpleFilter(crit.getColumnName());
        this.simpleFilters.add(crit);
    }

    public Set<String> getAllColumnNames() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.addAll(this.getSimpleColumnNames());
        if (this.hasContainsFilter()) {
            set.addAll(Sets.newHashSet((Object[])this.containsFilter.getColumns()));
        }
        if (this.hasAdvancedFilter()) {
            set.addAll(Sets.newHashSet((Object[])this.advancedFilter.getColumns()));
        }
        return set;
    }

    public Set<String> getSimpleColumnNames() {
        LinkedHashSet names = Sets.newLinkedHashSet();
        for (SearchCriterion each : this.simpleFilters) {
            names.add(each.getColumnName());
        }
        return names;
    }

    public List<Filter> getAllFilters() {
        ArrayList result = Lists.newArrayList();
        if (this.hasAdvancedFilter()) {
            result.add(this.advancedFilter);
        }
        result.addAll(this.simpleFilters);
        if (this.hasContainsFilter()) {
            result.add(this.containsFilter);
        }
        return result;
    }

    public List<SearchCriterion> getSimpleFilters() {
        return this.simpleFilters;
    }

    public void setSimpleFilters(List<SearchCriterion> simpleFilters) {
        this.simpleFilters = simpleFilters;
    }

    public ContainsFilter getContainsFilter() {
        return this.containsFilter;
    }

    public void setContainsFilter(ContainsFilter containsFilter) {
        this.containsFilter = containsFilter;
    }

    public CompositeFilter getAdvancedFilter() {
        return this.advancedFilter;
    }

    public void setAdvancedFilter(CompositeFilter advancedFilter) {
        this.advancedFilter = advancedFilter;
        if (advancedFilter != null) {
            for (String each : advancedFilter.getColumns()) {
                this.removeSimpleFilter(each);
                if (!this.hasContainsFilter()) continue;
                this.containsFilter.remove(each);
            }
        }
    }

    public void setFilters(List<Filter> filters) {
        for (Filter each : filters) {
            if (each instanceof SearchCriterion) {
                this.simpleFilters.add((SearchCriterion)each);
                continue;
            }
            if (each instanceof ContainsFilter) {
                this.containsFilter = (ContainsFilter)each;
                continue;
            }
            if (!(each instanceof CompositeFilter)) continue;
            this.advancedFilter = (CompositeFilter)each;
        }
    }

    public void addReportFilter(ReportFilter filter) {
        if (filter == null) {
            return;
        }
        for (SearchCriterion each : filter.getSimpleFilters()) {
            this.addSimpleFilter(each);
        }
        this.setContainsFilter(filter.getContainsFilter());
        this.setAdvancedFilter(filter.getAdvancedFilter());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ReportFilter)) {
            return false;
        }
        ReportFilter rhs = (ReportFilter)other;
        return Objects.equal(this.simpleFilters, rhs.simpleFilters) && Objects.equal((Object)this.containsFilter, (Object)rhs.containsFilter) && Objects.equal((Object)this.advancedFilter, (Object)rhs.advancedFilter);
    }

    public int hashcode() {
        return Objects.hashCode((Object[])new Object[]{this.simpleFilters, this.containsFilter, this.advancedFilter});
    }
}

