/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datastore.filter;

import com.google.common.base.Objects;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.FilterPriority;

public class NotExpression
implements Filter {
    private static final long serialVersionUID = 1L;
    private final Filter original;

    public NotExpression(Filter original) {
        this.original = original;
    }

    @Override
    public String toSqlString() {
        return "not (" + this.original.toSqlString() + ")";
    }

    @Override
    public Object[] getParams() {
        return this.original.getParams();
    }

    @Override
    public String[] getColumns() {
        return this.original.getColumns();
    }

    @Override
    public String toBreadcrumb() {
        return "excluding (" + this.original.toBreadcrumb() + ")";
    }

    @Override
    public FilterPriority getPriority() {
        return this.original.getPriority();
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof NotExpression)) {
            return false;
        }
        NotExpression rhs = (NotExpression)other;
        return Objects.equal((Object)this.original, (Object)rhs.original);
    }

    public int hashcode() {
        return Objects.hashCode((Object[])new Object[]{this.original});
    }

    public String toString() {
        return "not (" + this.original.toString() + ")";
    }
}

