/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datastore.filter;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Connective;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.FilterPriority;
import java.util.ArrayList;
import java.util.Arrays;

public class LogicExpression
implements Filter {
    private static final long serialVersionUID = 1L;
    private final Filter lhs;
    private final Filter rhs;
    private Connective connective;

    public LogicExpression(Filter lhs, Connective c, Filter rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
        this.connective = c;
    }

    @Override
    public String toSqlString() {
        StringBuffer sb = new StringBuffer();
        sb.append("(").append(this.lhs.toSqlString()).append(")").append(" ").append((Object)this.connective).append(" ").append("(").append(this.rhs.toSqlString()).append(")");
        return sb.toString();
    }

    @Override
    public Object[] getParams() {
        ArrayList result = Lists.newArrayList();
        result.addAll(Arrays.asList(this.lhs.getParams()));
        result.addAll(Arrays.asList(this.rhs.getParams()));
        return Iterables.toArray((Iterable)result, Object.class);
    }

    @Override
    public String[] getColumns() {
        ArrayList list = Lists.newArrayList();
        list.addAll(Arrays.asList(this.lhs.getColumns()));
        list.addAll(Arrays.asList(this.rhs.getColumns()));
        return (String[])Iterables.toArray((Iterable)list, String.class);
    }

    @Override
    public String toBreadcrumb() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.lhs.toBreadcrumb()).append(" ").append((Object)this.connective).append(this.rhs.toBreadcrumb());
        return sb.toString();
    }

    @Override
    public FilterPriority getPriority() {
        return FilterPriority.LOW;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof LogicExpression)) {
            return false;
        }
        LogicExpression r = (LogicExpression)other;
        return Objects.equal((Object)this.lhs, (Object)r.lhs) && Objects.equal((Object)((Object)this.connective), (Object)((Object)r.connective)) && Objects.equal((Object)this.rhs, (Object)r.rhs);
    }

    public int hashcode() {
        return Objects.hashCode((Object[])new Object[]{this.lhs, this.connective, this.rhs});
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.lhs).append(" ").append((Object)this.connective).append(" ").append(this.rhs);
        return sb.toString();
    }
}

