/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datastore.filter;

import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Func;
import com.pmease.quickbuild.plugin.report.engine.exception.ReportException;

public class Funcs {
    private Funcs() {
    }

    public static enum AnyFunc implements Func
    {
        EQUAL("Equals", "="),
        NOT_EQUAL("Not equal", "!="),
        LESS_THAN("Less than", "<"),
        LESS_EQUAL_THAN("Less or equal", "<="),
        GREATER_THAN("Greater than", ">"),
        GREATER_EQUAL_THAN("Greater or equal", ">=");

        private final String displayName;
        private final String sqlOp;

        private AnyFunc(String displayName, String sqlOp) {
            this.displayName = displayName;
            this.sqlOp = sqlOp;
        }

        @Override
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        public String getSqlOp() {
            return this.sqlOp;
        }

        public static AnyFunc fromDisplayName(String name) {
            for (AnyFunc each : AnyFunc.values()) {
                if (!each.getDisplayName().equalsIgnoreCase(name)) continue;
                return each;
            }
            throw new ReportException("Can't convert '" + name + "' to a valid function.");
        }

        public static AnyFunc fromSqlOp(String op) {
            for (AnyFunc each : AnyFunc.values()) {
                if (!each.getSqlOp().equalsIgnoreCase(op.trim())) continue;
                return each;
            }
            throw new ReportException("Can't convert sql operation '" + op + "' to a valid function.");
        }
    }

    public static enum NumberFunc implements Func
    {
        EQUAL("Equals", "="),
        GREATER_THAN("Greater than", ">"),
        LESS_THAN("Less than", "<");

        private final String displayName;
        private final String sqlOp;

        private NumberFunc(String displayName, String sqlOp) {
            this.displayName = displayName;
            this.sqlOp = sqlOp;
        }

        @Override
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        public String getSqlOp() {
            return this.sqlOp;
        }

        public static StringFunc fromDisplayName(String name) {
            for (StringFunc each : StringFunc.values()) {
                if (!each.getDisplayName().equalsIgnoreCase(name)) continue;
                return each;
            }
            throw new ReportException("Can't convert '" + name + "' to a number function.");
        }
    }

    public static enum EnumFunc implements Func
    {
        EQUAL("Equals");

        private final String displayName;

        private EnumFunc(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        public String getSqlOp() {
            return "=";
        }

        public static EnumFunc fromDisplayName(String name) {
            return EQUAL;
        }
    }

    public static enum StringFunc implements Func
    {
        EQUAL("Exactly Matching"),
        START_WITH("Begins With"),
        END_WITH("Ends With"),
        CONTAINING("Containing"),
        REGEX_MATCH("Matching RegExp");

        private final String displayName;

        private StringFunc(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        public String getSqlOp() {
            if (this == EQUAL) {
                return "=";
            }
            return "like";
        }

        public static StringFunc fromDisplayName(String name) {
            for (StringFunc each : StringFunc.values()) {
                if (!each.getDisplayName().equalsIgnoreCase(name)) continue;
                return each;
            }
            throw new ReportException("Can't convert '" + name + "' to a string function.");
        }
    }
}

