/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datastore.filter;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Connective;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.FilterPriority;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Restrictions;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.SearchCriterion;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ContainsFilter
implements Filter {
    private static final long serialVersionUID = 1L;
    private final List<String> columnNames = Lists.newArrayList();
    private Map<String, Filter> likes = Maps.newLinkedHashMap();
    private final String pattern;

    public ContainsFilter(String names, String pattern) {
        this.columnNames.addAll(Arrays.asList(ReportUtils.splitCsv(names)));
        this.pattern = pattern;
        for (String each : this.columnNames) {
            this.likes.put(each, Restrictions.like(each, pattern));
        }
    }

    public ContainsFilter(ContainsFilter other) {
        this.columnNames.addAll(other.columnNames);
        this.pattern = other.pattern;
        this.likes.putAll(other.likes);
    }

    public void remove(String columnName) {
        this.columnNames.remove(columnName);
        this.likes.remove(columnName);
    }

    public int size() {
        return this.columnNames.size();
    }

    public boolean isEmpty() {
        return this.columnNames.isEmpty();
    }

    public boolean isValid() {
        return !this.isEmpty() && !Strings.isNullOrEmpty((String)this.pattern);
    }

    @Override
    public String toSqlString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        if (this.likes.size() > 1) {
            sb.append("(");
        }
        for (Filter each : this.likes.values()) {
            sb.append(each.toSqlString());
            if (i < this.likes.size() - 1) {
                sb.append(" ").append((Object)Connective.OR).append(" ");
            }
            ++i;
        }
        if (this.likes.size() > 1) {
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    public Object[] getParams() {
        Object[] values = new String[this.likes.size()];
        int i = 0;
        for (Filter each : this.likes.values()) {
            values[i++] = (String)((SearchCriterion)each).getActualValue();
        }
        return values;
    }

    public String getPattern() {
        return this.pattern;
    }

    @Override
    public String[] getColumns() {
        return (String[])Iterables.toArray(this.columnNames, String.class);
    }

    @Override
    public String toBreadcrumb() {
        return "containing [" + this.pattern + "]";
    }

    @Override
    public FilterPriority getPriority() {
        return FilterPriority.LOW;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof ContainsFilter)) {
            return false;
        }
        ContainsFilter rhs = (ContainsFilter)other;
        if (!Objects.equal((Object)this.pattern, (Object)rhs.pattern)) {
            return false;
        }
        if (this.columnNames.size() != rhs.columnNames.size()) {
            return false;
        }
        return rhs.columnNames.containsAll(this.columnNames);
    }

    public int hashcode() {
        return Objects.hashCode((Object[])new Object[]{this.pattern, this.columnNames});
    }

    public String toString() {
        return Joiner.on((String)", ").join(this.columnNames) + " containing [" + this.pattern + "]";
    }
}

