/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datastore.filter;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.FilterPriority;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.SearchCriterion;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CompositeFilter
implements Filter {
    private static final long serialVersionUID = 1L;
    private List<SearchCriterion> criterions = Lists.newArrayList();

    public CompositeFilter() {
    }

    public CompositeFilter(List<SearchCriterion> criterions) {
        if (criterions != null) {
            this.criterions = Lists.newArrayList(criterions);
        }
    }

    public CompositeFilter(CompositeFilter other) {
        if (other != null && !other.isEmpty()) {
            for (SearchCriterion each : other.criterions) {
                this.criterions.add(each.clone());
            }
        }
    }

    public int size() {
        return this.criterions.size();
    }

    public void clear() {
        this.criterions.clear();
    }

    public boolean isEmpty() {
        return this.criterions.isEmpty();
    }

    public boolean isValid() {
        return !this.isEmpty();
    }

    public void remove(String columnName) {
        Iterator<SearchCriterion> it = this.criterions.iterator();
        while (it.hasNext()) {
            SearchCriterion each = it.next();
            if (!each.getColumnName().equalsIgnoreCase(columnName)) continue;
            it.remove();
        }
    }

    @Override
    public String toSqlString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        if (this.criterions.size() > 1) {
            sb.append("(");
        }
        for (SearchCriterion each : this.criterions) {
            if (each.isValid()) {
                sb.append(each.toSqlString());
            }
            if (i + 1 < this.criterions.size()) {
                sb.append(" ").append((Object)each.getConnective()).append(" ");
            }
            ++i;
        }
        if (this.criterions.size() > 1) {
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    public Object[] getParams() {
        ArrayList list = Lists.newArrayList();
        for (SearchCriterion each : this.criterions) {
            list.add(each.getActualValue());
        }
        return Iterables.toArray((Iterable)list, Object.class);
    }

    @Override
    public String[] getColumns() {
        ArrayList list = Lists.newArrayList();
        for (SearchCriterion each : this.criterions) {
            list.add(each.getColumnName());
        }
        return (String[])Iterables.toArray((Iterable)list, String.class);
    }

    @Override
    public String toBreadcrumb() {
        return this.toString();
    }

    @Override
    public FilterPriority getPriority() {
        return FilterPriority.HIGH;
    }

    public List<SearchCriterion> getCriterions() {
        return this.criterions;
    }

    public void setCriterions(List<SearchCriterion> criterions) {
        this.criterions = criterions;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof CompositeFilter)) {
            return false;
        }
        CompositeFilter rhs = (CompositeFilter)other;
        return this.criterions.size() == rhs.criterions.size() && this.criterions.containsAll(rhs.criterions);
    }

    public int hashcode() {
        return Objects.hashCode((Object[])new Object[]{this.criterions});
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        for (SearchCriterion each : this.criterions) {
            sb.append(each);
            if (i + 1 < this.criterions.size()) {
                sb.append(" ").append((Object)each.getConnective()).append(" ");
            }
            ++i;
        }
        return sb.toString();
    }
}

