/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datastore.duplicate;

import com.pmease.quickbuild.plugin.report.engine.datareport.DataColumn;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportMetaData;
import com.pmease.quickbuild.plugin.report.engine.datastore.MergeFunction;
import com.pmease.quickbuild.plugin.report.engine.datastore.duplicate.CollectionAppend;
import com.pmease.quickbuild.plugin.report.engine.datastore.duplicate.LogicalAnd;
import com.pmease.quickbuild.plugin.report.engine.datastore.duplicate.MathAdd;
import com.pmease.quickbuild.plugin.report.engine.datatype.BooleanType;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import java.util.Collection;

public class DataRowMerger
implements MergeFunction<DataRow> {
    @Override
    public DataRow process(DataRow currentRow, DataRow newRow) {
        ReportMetaData meta = newRow.getReport().getMeta();
        DataColumn[] columns = meta.getColumns();
        ReportMetaData sourceMeta = currentRow.getReport().getMeta();
        for (DataColumn each : columns) {
            if (each.getDataType().isIdType() || each.isPrimary() || !sourceMeta.hasColumn(each.getColumnName())) continue;
            DataType dataType = each.getDataType();
            Object value1 = currentRow.getValue(each.getColumnName());
            Object value2 = newRow.getValue(each.getColumnName());
            Object value = dataType.isNumericType() ? new MathAdd().process((Number)value1, (Number)value2) : (dataType.isCollectionType() ? new CollectionAppend().process((Collection)value1, (Collection)value2) : (dataType instanceof BooleanType ? new LogicalAnd().process((Boolean)value1, (Boolean)value2) : value1));
            newRow.setValue(each.getColumnName(), value);
        }
        return newRow;
    }
}

