/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datastore;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.datastore.Order;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Restrictions;
import com.pmease.quickbuild.plugin.report.engine.util.CaseInsensitiveMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SqlBuilder {
    SqlCommand command;
    List<String> selectColumns = Lists.newArrayList();
    List<String> tables = Lists.newArrayList();
    List<String> groupByColumns = Lists.newArrayList();
    List<Order> orders = Lists.newArrayList();
    int top = 0;
    boolean distinct = false;
    int limit = 0;
    int offset = 0;
    List<Filter> filters = Lists.newArrayList();
    Map<String, Object> values = CaseInsensitiveMap.create(new LinkedHashMap());
    String leftJoin;
    String outerJoin;
    String on;

    SqlBuilder() {
    }

    public static SqlBuilder query() {
        SqlBuilder query = new SqlBuilder();
        query.command = SqlCommand.SELECT;
        return query;
    }

    public static SqlBuilder insert(String table) {
        SqlBuilder query = new SqlBuilder();
        query.command = SqlCommand.INSERT;
        query.tables.add(table);
        return query;
    }

    public static SqlBuilder merge(String table) {
        SqlBuilder query = new SqlBuilder();
        query.command = SqlCommand.MERGE;
        query.tables.add(table);
        return query;
    }

    public static SqlBuilder update(String table) {
        SqlBuilder query = new SqlBuilder();
        query.command = SqlCommand.UPDATE;
        query.tables.add(table);
        return query;
    }

    public static SqlBuilder deleteFrom(String table) {
        SqlBuilder query = new SqlBuilder();
        query.command = SqlCommand.DELETE;
        query.tables.add(table);
        return query;
    }

    public SqlBuilder select(String ... columnNames) {
        this.selectColumns.addAll(Arrays.asList(columnNames));
        return this;
    }

    public SqlBuilder top(int n) {
        this.top = n;
        return this;
    }

    public SqlBuilder distinct(boolean b) {
        this.distinct = b;
        return this;
    }

    public SqlBuilder from(String ... tableNames) {
        this.tables.addAll(Arrays.asList(tableNames));
        return this;
    }

    public SqlBuilder leftJoin(String table) {
        this.leftJoin = table;
        return this;
    }

    public SqlBuilder on(String on) {
        this.on = on;
        return this;
    }

    public SqlBuilder where(String str) {
        if (!Strings.isNullOrEmpty((String)str)) {
            this.filters.add(Restrictions.directSql(str));
        }
        return this;
    }

    public SqlBuilder where(List<? extends Filter> list) {
        if (list == null || list.isEmpty()) {
            return this;
        }
        for (Filter filter : list) {
            if (filter == null) continue;
            this.filters.add(filter);
        }
        return this;
    }

    public SqlBuilder where(Filter ... array) {
        if (array == null || array.length == 0) {
            return this;
        }
        return this.where(Lists.newArrayList((Object[])array));
    }

    public SqlBuilder groupby(String ... columnNames) {
        this.groupByColumns.addAll(Arrays.asList(columnNames));
        return this;
    }

    public SqlBuilder orderby(Order ... orders) {
        this.orders.addAll(Arrays.asList(orders));
        return this;
    }

    public SqlBuilder orderby(List<Order> orders) {
        return this.orderby((Order[])Iterables.toArray(orders, Order.class));
    }

    public SqlBuilder limit(int limits) {
        this.limit = limits;
        return this;
    }

    public SqlBuilder offset(int offsets) {
        this.offset = offsets;
        return this;
    }

    public SqlBuilder values(String[] columns, Object[] values) {
        Preconditions.checkArgument((columns.length == values.length ? 1 : 0) != 0);
        for (int i = 0; i < columns.length; ++i) {
            this.values.put(columns[i], values[i]);
        }
        return this;
    }

    public SqlBuilder clearOrderBy() {
        this.orders.clear();
        return this;
    }

    public SqlBuilder clearGroupBy() {
        this.groupByColumns.clear();
        return this;
    }

    public SqlBuilder clearFilters() {
        this.filters.clear();
        return this;
    }

    static String join(List<String> list) {
        return Joiner.on((char)',').skipNulls().join(list);
    }

    String getWhere() {
        if (this.filters.isEmpty()) {
            return "";
        }
        ArrayList list = Lists.newArrayList();
        for (Filter each : this.filters) {
            String sql = each.toSqlString();
            if (Strings.isNullOrEmpty((String)sql)) continue;
            list.add(each.toSqlString());
        }
        String where = Joiner.on((String)" AND ").skipNulls().join((Iterable)list);
        if (Strings.isNullOrEmpty((String)where)) {
            return "";
        }
        return new StringBuffer(" WHERE ").append(where).toString();
    }

    List<Object> getWhereParams() {
        if (this.filters.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList params = Lists.newArrayList();
        for (Filter each : this.filters) {
            params.addAll(Arrays.asList(each.getParams()));
        }
        return params;
    }

    String toSelect() {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ");
        if (this.top > 0) {
            sb.append(" TOP ").append(this.top);
        }
        if (this.distinct) {
            sb.append(" DISTINCT ");
        }
        sb.append(SqlBuilder.join(this.selectColumns)).append(" FROM ").append(SqlBuilder.join(this.tables));
        if (!Strings.isNullOrEmpty((String)this.leftJoin)) {
            sb.append(" LEFT JOIN ").append(this.leftJoin);
        }
        if (!Strings.isNullOrEmpty((String)this.on)) {
            sb.append(" ON ").append(this.on);
        }
        sb.append(this.getWhere());
        if (this.groupByColumns.size() > 0) {
            sb.append(" GROUP BY ").append(SqlBuilder.join(this.groupByColumns));
        }
        if (this.orders.size() > 0) {
            sb.append(" ORDER BY ");
            for (int i = 0; i < this.orders.size(); ++i) {
                sb.append(this.orders.get(i).toSqlString());
                if (i + 1 >= this.orders.size()) continue;
                sb.append(", ");
            }
        }
        if (this.limit > 0) {
            sb.append(" LIMIT ").append(this.limit);
        }
        if (this.offset > 0) {
            sb.append(" OFFSET ").append(this.offset);
        }
        return sb.toString();
    }

    String toUpdate() {
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE ").append(this.tables.get(0)).append(" SET ");
        int i = 0;
        for (String each : this.values.keySet()) {
            sb.append(each).append("= ?");
            if (i + 1 < this.values.size()) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append(this.getWhere());
        return sb.toString();
    }

    String toInsert() {
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ").append(this.tables.get(0));
        int i = 0;
        sb.append("(");
        for (String each : this.values.keySet()) {
            sb.append(each);
            if (i + 1 < this.values.size()) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append(") VALUES (");
        for (i = 0; i < this.values.size(); ++i) {
            sb.append("?");
            if (i + 1 >= this.values.size()) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    String toMerge() {
        StringBuffer sb = new StringBuffer();
        sb.append("MERGE INTO ").append(this.tables.get(0));
        int i = 0;
        sb.append("(");
        for (String each : this.values.keySet()) {
            sb.append(each);
            if (i + 1 >= this.values.size()) continue;
            sb.append(",");
        }
        sb.append(") ");
        sb.append("KEY(ID) ");
        sb.append("VALUES(");
        for (i = 0; i < this.values.size(); ++i) {
            sb.append("?");
            if (i + 1 >= this.values.size()) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    String toDelete() {
        StringBuffer sb = new StringBuffer();
        sb.append("DELETE FROM ").append(this.tables.get(0));
        sb.append(this.getWhere());
        return sb.toString();
    }

    public Object[] getParams() {
        List<Object> params = Lists.newArrayList();
        switch (this.command) {
            case SELECT: 
            case DELETE: {
                params = this.getWhereParams();
                break;
            }
            case UPDATE: {
                params.addAll(this.values.values());
                params.addAll(this.getWhereParams());
                break;
            }
            case INSERT: {
                params.addAll(this.values.values());
                break;
            }
        }
        return Iterables.toArray((Iterable)params, Object.class);
    }

    public String toSqlString() {
        switch (this.command) {
            case SELECT: {
                return this.toSelect();
            }
            case UPDATE: {
                return this.toUpdate();
            }
            case INSERT: {
                return this.toInsert();
            }
            case MERGE: {
                return this.toMerge();
            }
            case DELETE: {
                return this.toDelete();
            }
        }
        throw new IllegalArgumentException("Unknonw command " + (Object)((Object)this.command));
    }

    public SqlCommand getCommand() {
        return this.command;
    }

    public void setCommand(SqlCommand command) {
        this.command = command;
    }

    public List<String> getSelectColumns() {
        return this.selectColumns;
    }

    public void setSelectColumns(List<String> selectColumns) {
        this.selectColumns = selectColumns;
    }

    public List<String> getTables() {
        return this.tables;
    }

    public void setTables(List<String> tables) {
        this.tables = tables;
    }

    public List<String> getGroupByColumns() {
        return this.groupByColumns;
    }

    public void setGroupByColumns(List<String> groupByColumns) {
        this.groupByColumns = groupByColumns;
    }

    public List<Order> getOrders() {
        return this.orders;
    }

    public void setOrders(List<Order> orders) {
        this.orders = orders;
    }

    public int getTop() {
        return this.top;
    }

    public void setTop(int top) {
        this.top = top;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    public void setValues(Map<String, Object> values) {
        this.values = values;
    }

    static enum SqlCommand {
        SELECT,
        UPDATE,
        INSERT,
        MERGE,
        DELETE;

    }
}

