/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datastore;

import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.exception.DatabaseException;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.commons.dbutils.ResultSetHandler;

public class SingleObjectHandler<T>
implements ResultSetHandler<T> {
    private Class<T> requiredType;

    public SingleObjectHandler() {
    }

    public SingleObjectHandler(Class<T> requiredType) {
        this.requiredType = requiredType;
    }

    public T handle(ResultSet rs) throws SQLException {
        if (!rs.next()) {
            return null;
        }
        ResultSetMetaData rsmd = rs.getMetaData();
        int num = rsmd.getColumnCount();
        if (num != 1) {
            throw new DatabaseException("Incorrect column count in resultset, expected 1, total " + num);
        }
        if (this.requiredType == null) {
            return (T)rs.getObject(1);
        }
        DataType dataType = DataTypes.getDataType(this.requiredType);
        return (T)dataType.fromDbObject(rs, rsmd.getColumnName(1));
    }
}

