/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datastore;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportMetaData;
import com.pmease.quickbuild.plugin.report.engine.datastore.Order;
import com.pmease.quickbuild.plugin.report.engine.datastore.SqlBuilder;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.FilterDef;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.SimpleFilterDef;
import com.pmease.quickbuild.plugin.report.engine.metadata.AbstractCategoryItem;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.TypedObjects;
import com.pmease.quickbuild.plugin.report.engine.util.csv.CSVParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;

public class ReportDataSource
extends AbstractCategoryItem {
    private static final long serialVersionUID = 1L;
    @Alias
    private String select;
    @Alias
    private String excludes;
    @Alias
    private String from;
    @Alias
    private String orderBy;
    @Alias
    private String asc;
    @Alias
    private String groupBy;
    @Alias
    private int maxRows = 0;
    private List<FilterDef> filters = Lists.newArrayList();

    public ReportDataSource(ReportCategory category) {
        super(category);
    }

    public ReportDataSource(ReportCategory category, String table) {
        super(category);
        this.from = table;
    }

    public void deepCopy(ReportDataSource other) {
        if (other == null) {
            return;
        }
        this.select = other.select;
        this.excludes = other.excludes;
        this.from = other.from;
        this.filters = other.filters;
        this.orderBy = other.orderBy;
        this.asc = other.asc;
        this.groupBy = other.groupBy;
        this.maxRows = other.maxRows;
    }

    public String getMainTable() {
        String[] names = new CSVParser().parse(this.from);
        if (names.length > 0) {
            return names[0];
        }
        return null;
    }

    public List<Filter> getDbFilters() {
        return this.getDbFilters(null);
    }

    public List<Filter> getDbFilters(Map<String, Object> context) {
        ArrayList list = Lists.newArrayList();
        for (FilterDef each : this.filters) {
            list.add(each.toFilter(context));
        }
        return list;
    }

    public SqlBuilder toQuery(Map<String, Object> context) {
        SqlBuilder query = SqlBuilder.query();
        CSVParser parser = new CSVParser();
        String[] tables = parser.parse(this.from);
        ArrayList columnNames = Lists.newArrayList();
        if (tables.length == 1 && (Strings.isNullOrEmpty((String)this.select) || "*".equalsIgnoreCase(this.select)) && Strings.isNullOrEmpty((String)this.excludes)) {
            query.select("*");
        } else {
            if (Strings.isNullOrEmpty((String)this.select) || "*".equals(this.select)) {
                for (String each : tables) {
                    ReportMetaData meta = this.category.getMeta(each);
                    for (String column : meta.getColumnNames()) {
                        if (tables.length > 1) {
                            columnNames.add(each + "." + column);
                            continue;
                        }
                        columnNames.add(column);
                    }
                }
            } else {
                columnNames = Lists.newArrayList((Object[])parser.parse(this.select));
            }
            if (!Strings.isNullOrEmpty((String)this.excludes)) {
                String[] tokens;
                for (String each : tokens = parser.parse(this.excludes)) {
                    columnNames.remove(each);
                }
            }
        }
        query.select((String[])Iterables.toArray((Iterable)columnNames, String.class));
        query.from(tables);
        query.where(this.getDbFilters(context));
        if (!Strings.isNullOrEmpty((String)this.groupBy)) {
            query.groupby(parser.parse(this.groupBy));
        }
        if (!Strings.isNullOrEmpty((String)this.orderBy)) {
            String[] columns = parser.parse(this.orderBy);
            String[] ascs = parser.parse(this.asc);
            ArrayList orders = Lists.newArrayList();
            for (int i = 0; i < columns.length; ++i) {
                boolean ascending = ascs.length == 0 ? true : (i + 1 < ascs.length ? Boolean.valueOf(ascs[i]).booleanValue() : Boolean.valueOf(ascs[ascs.length - 1]).booleanValue());
                orders.add(new Order(columns[i], ascending));
            }
            query.orderby((Order[])Iterables.toArray((Iterable)orders, Order.class));
        }
        query.limit(this.maxRows);
        return query;
    }

    public SqlBuilder toQuery() {
        return this.toQuery(null);
    }

    @Override
    public void fromXML(Element node) {
        super.fromXML(node);
        List nodes = node.elements("filter");
        for (Element each : nodes) {
            FilterDef filter = TypedObjects.createTypedObject(each, FilterDef.class, new SimpleFilterDef(), new Object[0]);
            filter.fromXML(each);
            this.addFilter(filter);
        }
    }

    public void addFilter(FilterDef filter) {
        this.filters.add(filter);
    }

    @Override
    public String getType() {
        return "DEFAULT";
    }

    @Override
    public String getElementName() {
        return "data-source";
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public List<FilterDef> getFilters() {
        return this.filters;
    }

    public void setSimpleFilters(List<FilterDef> filters) {
        this.filters = filters;
    }

    public String getSelect() {
        return this.select;
    }

    public void setSelect(String select) {
        this.select = select;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public String getAsc() {
        return this.asc;
    }

    public void setAsc(String asc) {
        this.asc = asc;
    }

    public String getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(String groupBy) {
        this.groupBy = groupBy;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }
}

