/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datastore;

import com.google.common.base.Preconditions;
import com.pmease.quickbuild.annotation.Date;
import com.pmease.quickbuild.plugin.report.engine.datastore.ConnectionCache;
import com.pmease.quickbuild.plugin.report.engine.datastore.ConnectionManager;
import com.pmease.quickbuild.plugin.report.engine.datastore.SingleObjectHandler;
import com.pmease.quickbuild.plugin.report.engine.datastore.SqlBuilder;
import com.pmease.quickbuild.plugin.report.engine.exception.DatabaseException;
import com.pmease.quickbuild.util.LockUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.dbutils.handlers.MapHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DbStore {
    protected static final Logger logger = LoggerFactory.getLogger(DbStore.class);
    protected File dbDir;
    protected Connection connection;
    private Lock lock = null;
    private Mode mode = Mode.READ_ONLY;
    private String method = "";

    protected abstract String getDbName();

    protected abstract void createDb();

    protected DbStore(File dbDir) {
        this.dbDir = dbDir;
    }

    public <T> T query(SqlBuilder sb, ResultSetHandler<T> rsh) {
        return this.query(sb.toSqlString(), rsh, sb.getParams());
    }

    public <T> T query(String sql, ResultSetHandler<T> rsh) {
        return this.query(sql, rsh, new Object[0]);
    }

    public <T> T query(String sql, ResultSetHandler<T> rsh, Object[] params) {
        if (logger.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer().append("Executing query[ ").append(sql).append("] on database: ").append(this);
            if (params != null) {
                sb.append("\n\tParams: \n\t\t");
                for (Object each : params) {
                    if (each == null) {
                        sb.append("null, ");
                        continue;
                    }
                    sb.append(each).append(", ");
                }
            }
            logger.debug(sb.toString());
        }
        QueryRunner runner = new QueryRunner();
        try {
            return (T)runner.query(this.connection, sql, rsh, params);
        }
        catch (SQLException e) {
            throw new DatabaseException("Failed executing query [" + sql + "] on database " + this, e);
        }
    }

    public <T> T queryForObject(String sql, Class<T> requiredType) {
        return this.query(sql, new SingleObjectHandler<T>(requiredType));
    }

    public <T> T queryForObject(SqlBuilder sb, Class<T> requiredType) {
        return this.query(sb, new SingleObjectHandler<T>(requiredType));
    }

    public <T> T queryForObject(String sql, Class<T> requiredType, Object[] params) {
        return this.query(sql, new SingleObjectHandler<T>(requiredType), params);
    }

    public Integer queryForInt(String sql) {
        return this.queryForObject(sql, Integer.class);
    }

    public Long queryForLong(String sql) {
        return this.queryForObject(sql, Long.class);
    }

    public Double queryForDouble(String sql) {
        return this.queryForObject(sql, Double.class);
    }

    public String queryForString(String sql) {
        return this.queryForObject(sql, String.class);
    }

    public Integer queryForInt(SqlBuilder sb) {
        return this.queryForObject(sb, Integer.class);
    }

    public Long queryForLong(SqlBuilder sb) {
        return this.queryForObject(sb, Long.class);
    }

    public Double queryForDouble(SqlBuilder sb) {
        return this.queryForObject(sb, Double.class);
    }

    public Date queryForDate(SqlBuilder sb) {
        return this.queryForObject(sb, Date.class);
    }

    public Calendar queryForTime(SqlBuilder sb) {
        return this.queryForObject(sb, Calendar.class);
    }

    public Map<String, Object> queryForMap(String sql) {
        return (Map)this.query(sql, (ResultSetHandler)new MapHandler());
    }

    public Map<String, Object> queryForMap(SqlBuilder sb) {
        return (Map)this.query(sb, (ResultSetHandler)new MapHandler());
    }

    public List<Map<String, Object>> queryForMapList(SqlBuilder sb) {
        return (List)this.query(sb, (ResultSetHandler)new MapListHandler());
    }

    public List<Map<String, Object>> queryForMapList(String sql) {
        return (List)this.query(sql, (ResultSetHandler)new MapListHandler());
    }

    public List<Object[]> queryForArrayList(SqlBuilder sb) {
        return (List)this.query(sb, (ResultSetHandler)new ArrayListHandler());
    }

    public List<Object[]> queryForArrayList(String sql) {
        return (List)this.query(sql, (ResultSetHandler)new ArrayListHandler());
    }

    public <T> List<T> queryForBeanList(SqlBuilder sb, Class<T> requiredType) {
        return (List)this.query(sb, (ResultSetHandler<T>)new BeanListHandler(requiredType));
    }

    void checkWritable() {
        if (this.isClosed() || this.isReadOnly()) {
            throw new DatabaseException("Invalid database connection! The connection is read only or connection is closed.");
        }
    }

    public void update(String sql) {
        this.update(sql, new Object[0]);
    }

    public void update(String sql, Object[] params) {
        this.checkWritable();
        if (logger.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer().append("Executing update query[ ").append(sql).append("] on database: ").append(this);
            if (params != null) {
                sb.append("\n\tParams: \n\t\t");
                for (Object each : params) {
                    sb.append(each).append(", ");
                }
            }
            logger.debug(sb.toString());
        }
        QueryRunner runner = new QueryRunner();
        try {
            runner.update(this.connection, sql, params);
        }
        catch (SQLException e) {
            throw new DatabaseException("Failed executing update sql [" + sql + "] on database " + this, e);
        }
    }

    public void update(SqlBuilder sb) {
        this.update(sb.toSqlString(), sb.getParams());
    }

    public void beginTransaction() {
        try {
            this.connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws SQLException {
        try {
            this.connection.commit();
        }
        finally {
            this.connection.setAutoCommit(true);
        }
    }

    public void rollback() {
        try {
            this.connection.rollback();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    public boolean isClosed() {
        try {
            return this.connection == null || this.connection.isClosed();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    protected Lock getLock() {
        File dir = this.getLockDir();
        if (logger.isDebugEnabled()) {
            logger.debug("Getting lock - " + dir + ":" + (Object)((Object)this.mode));
        }
        if (this.mode == Mode.READ_ONLY) {
            return LockUtils.lockForRead((File)dir);
        }
        return LockUtils.lockForWrite((File)dir);
    }

    protected File getLockDir() {
        return this.getDbDir();
    }

    public void open(Mode mode) {
        this.open(mode, "DbStore::open");
    }

    public void open(Mode mode, String method) {
        if (logger.isDebugEnabled()) {
            logger.debug("Trying opening the database " + this + " ...");
        }
        Preconditions.checkState((this.connection == null ? 1 : 0) != 0);
        Preconditions.checkState((this.lock == null ? 1 : 0) != 0);
        this.method = method;
        try {
            ConnectionCache.INSTANCE.put(this.dbDir.getAbsolutePath(), mode, method);
            if (!this.exists()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Database doesn't exist, creating database " + this + " and opening with READ_WRITE mode");
                }
                this.mode = Mode.READ_WRITE;
                this.lock = this.getLock();
                this.connection = this.getConnection(this.getUrl());
                this.createDb();
            } else {
                File lockFile = new File(this.getDbDir(), this.getDbName() + ".lock.db");
                if (mode == Mode.READ_ONLY && !lockFile.exists()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Opening database " + this + " in READ_ONLY mode");
                    }
                    this.mode = Mode.READ_ONLY;
                    this.lock = this.getLock();
                    this.connection = this.getConnection(this.getUrl());
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Opening database " + this + " in READ_WRITE mode ...");
                    }
                    this.mode = Mode.READ_WRITE;
                    this.lock = this.getLock();
                    this.connection = this.getConnection(this.getUrl());
                }
            }
        }
        catch (Throwable e) {
            this.close();
            throw new DatabaseException("Open database [" + this.dbDir.getAbsolutePath() + "] failed. " + "Database status [" + ConnectionCache.INSTANCE.dump(this.dbDir.getAbsolutePath()) + "].", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (logger.isDebugEnabled()) {
            logger.debug("Closing database " + this + " and releasing lock");
        }
        try {
            DbUtils.closeQuietly((Connection)this.connection);
            ConnectionCache.INSTANCE.remove(this.dbDir.getAbsolutePath(), this.mode, this.method);
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
                this.lock = null;
            }
        }
    }

    protected Connection getConnection(String url) {
        if (logger.isDebugEnabled()) {
            logger.debug("Getting connection, url: " + url);
        }
        return ConnectionManager.INSTANCE.getConnection(url);
    }

    protected String getUrl() {
        String url = "jdbc:h2:" + this.getDbPath();
        url = StringUtils.replace((String)url, (String)"\\", (String)"/");
        if (this.isReadOnly()) {
            url = url + ";ACCESS_MODE_DATA=r";
        }
        return url;
    }

    public String getDbPath() {
        return new File(this.dbDir, this.getDbName()).getAbsolutePath();
    }

    public File getDbFile() {
        return new File(this.getDbPath() + ".h2.db");
    }

    public boolean exists() {
        File file = this.getDbFile();
        return file.exists();
    }

    public boolean isReadOnly() {
        return this.mode == Mode.READ_ONLY;
    }

    public File getDbDir() {
        return this.dbDir;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Mode getMode() {
        return this.mode;
    }

    public String toString() {
        return this.getDbFile().getAbsolutePath();
    }

    public static enum Mode {
        READ_ONLY,
        READ_WRITE;

    }
}

