/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datastore;

import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportMetaData;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.commons.dbutils.ResultSetHandler;

public class DataRowMapper
implements ResultSetHandler<DataRow> {
    private final DataRow row;

    public DataRowMapper(DataRow row) {
        this(row, null);
    }

    public DataRowMapper(DataRow row, String[] columns) {
        this.row = row;
    }

    public DataRow handle(ResultSet rs) throws SQLException {
        if (!rs.next()) {
            return null;
        }
        this.extractRow(this.row, rs);
        return this.row;
    }

    public void extractRow(DataRow row, ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        ReportMetaData meta = row.getReport().getMeta();
        int count = rsmd.getColumnCount();
        for (int i = 1; i <= count; ++i) {
            String columnName = rsmd.getColumnName(i);
            if (!meta.hasColumn(columnName)) continue;
            DataType dataType = meta.getColumn(columnName).getDataType();
            row.setValue(columnName, dataType.fromDbObject(rs, columnName));
        }
    }
}

