/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datastore;

import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportMetaData;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.commons.dbutils.ResultSetHandler;

public class DataReportMapper
implements ResultSetHandler<DataReport> {
    protected final DataReport report;

    public DataReportMapper(DataReport report) {
        this.report = report;
    }

    public DataReport handle(ResultSet rs) throws SQLException {
        while (rs.next()) {
            DataRow row = this.report.addRow();
            this.extractRow(row, rs);
        }
        return this.report;
    }

    public void extractRow(DataRow row, ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        ReportMetaData meta = row.getReport().getMeta();
        int count = rsmd.getColumnCount();
        for (int i = 1; i <= count; ++i) {
            String columnName = rsmd.getColumnName(i);
            if (!meta.hasColumn(columnName)) continue;
            DataType dataType = meta.getColumn(columnName).getDataType();
            row.setValue(columnName, dataType.fromDbObject(rs, columnName));
        }
    }
}

