/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datastore;

import com.pmease.quickbuild.plugin.report.engine.exception.DatabaseException;
import com.pmease.quickbuild.util.ExceptionUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public enum ConnectionManager {
    INSTANCE;


    private ConnectionManager() {
        try {
            Class.forName("org.h2.Driver");
        }
        catch (ClassNotFoundException e) {
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
    }

    public Connection getConnection(String url) {
        try {
            return DriverManager.getConnection(url, "sa", "");
        }
        catch (SQLException e) {
            throw new DatabaseException("Unable to get connection from database url: " + url, e);
        }
    }
}

