/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datastore;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;

public enum ConnectionCache {
    INSTANCE;

    private Multimap<String, Usage> usages = Multimaps.synchronizedListMultimap((ListMultimap)LinkedListMultimap.create());

    public void put(String url, Usage usage) {
        this.usages.put((Object)url, (Object)usage);
    }

    public void put(String url, DbStore.Mode mode, String method) {
        this.put(url, new Usage(mode, method));
    }

    public void remove(String url, Usage usage) {
        this.usages.remove((Object)url, (Object)usage);
    }

    public void remove(String url, DbStore.Mode mode, String method) {
        this.remove(url, new Usage(mode, method));
    }

    public boolean isEmpty() {
        return this.usages.isEmpty();
    }

    public Collection<Usage> getStatus(String url) {
        return this.usages.get((Object)url);
    }

    public String dump() {
        StringBuffer sb = new StringBuffer();
        Map map = this.usages.asMap();
        for (String key : map.keySet()) {
            sb.append(key).append(": [");
            sb.append(this.dump(key));
            sb.append("]\n");
        }
        return sb.toString();
    }

    public String dump(String url) {
        Collection list = this.usages.get((Object)url);
        if (list.isEmpty()) {
            return "No active connections";
        }
        return Joiner.on((String)", ").join((Iterable)this.usages.get((Object)url));
    }

    public static void main(String[] args) {
        INSTANCE.put("abc", new Usage(DbStore.Mode.READ_ONLY, "Category::open"));
        INSTANCE.put("abc", new Usage(DbStore.Mode.READ_ONLY, "Category::open"));
        INSTANCE.put("abcd", new Usage(DbStore.Mode.READ_ONLY, "Category::delete"));
        INSTANCE.put("abc", new Usage(DbStore.Mode.READ_WRITE, "Category::migrate"));
        INSTANCE.remove("abc", new Usage(DbStore.Mode.READ_ONLY, "Category::open"));
        INSTANCE.remove("abc", new Usage(DbStore.Mode.READ_ONLY, "abc::open"));
        System.out.println(INSTANCE.dump());
    }

    public static class Usage
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String method;
        private DbStore.Mode mode;

        public Usage(DbStore.Mode mode, String method) {
            this.mode = mode;
            this.method = method;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.mode, this.method});
        }

        public String toString() {
            return this.method + "::" + (Object)((Object)this.mode);
        }

        public boolean equals(Object other) {
            if (!(other instanceof Usage)) {
                return false;
            }
            Usage rhs = (Usage)other;
            return Objects.equal((Object)((Object)this.mode), (Object)((Object)rhs.mode)) && Objects.equal((Object)this.method, (Object)rhs.method);
        }
    }
}

