/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datareport.io;

import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datareport.io.ReportReader;
import com.pmease.quickbuild.plugin.report.engine.util.XMLHelper;
import com.pmease.quickbuild.util.ExceptionUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.io.IOUtils;
import org.dom4j.Element;
import org.dom4j.io.STAXEventReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportStaxReader
extends STAXEventReader
implements ReportReader {
    private static final Logger logger = LoggerFactory.getLogger(ReportStaxReader.class);
    private DataReport destReport;
    private InputStream in;
    private XMLEventReader reader;
    private boolean stopReading = false;

    public ReportStaxReader(DataReport destReport, InputStream in) {
        this.destReport = destReport;
        this.in = in;
        this.reader = XMLHelper.createXMLEventReader(in);
    }

    public ReportStaxReader(DataReport report, File file) {
        this.destReport = report;
        try {
            this.in = new FileInputStream(file);
            this.reader = XMLHelper.createXMLEventReader(this.in);
        }
        catch (FileNotFoundException e) {
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((InputStream)this.in);
        try {
            this.reader.close();
        }
        catch (XMLStreamException e) {
            logger.error("Close inputstream failed! Ignored.", (Throwable)e);
        }
    }

    @Override
    public DataReport read() {
        try {
            while (this.reader.hasNext() && !this.stopReading) {
                XMLEvent nextEvent = this.reader.peek();
                int type = nextEvent.getEventType();
                if (type == 1) {
                    StartElement element;
                    StartElement s = nextEvent.asStartElement();
                    String elementName = s.getName().getLocalPart();
                    if (elementName.equalsIgnoreCase("report")) {
                        element = this.reader.nextEvent().asStartElement();
                        this.readReportInfo(element);
                        continue;
                    }
                    if (elementName.equalsIgnoreCase("row")) {
                        element = this.readElement(this.reader);
                        this.readRow((Element)element);
                        continue;
                    }
                    this.reader.nextEvent();
                    continue;
                }
                this.reader.nextEvent();
            }
        }
        catch (XMLStreamException e) {
            logger.error("This report is malformed.", (Throwable)e);
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
        this.onAfterRead();
        return this.destReport;
    }

    protected void readReportInfo(StartElement element) {
        Iterator<Attribute> it = element.getAttributes();
        while (it.hasNext()) {
            Attribute attr = it.next();
            String attrName = attr.getName().getLocalPart();
            if (ReportHelper.isEquals(attrName, "version") || !ReportHelper.isEquals(attrName, "locale")) continue;
            this.destReport.setLocale(ReportHelper.getLocale(attr.getValue()));
        }
    }

    protected void readRow(Element element) {
        DataRow row = this.destReport.createRow();
        row.fromXML(element);
        this.destReport.addRow(row).setId(row.getId());
    }

    protected void onAfterRead() {
    }

    @Override
    public String getType() {
        return "DEFAULT";
    }
}

