/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datareport.io;

import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datareport.io.ReportReader;
import com.pmease.quickbuild.plugin.report.engine.datastore.ReportDataSource;
import com.pmease.quickbuild.plugin.report.engine.util.XMLHelper;
import com.pmease.quickbuild.util.ExceptionUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.Element;

public class ReportSaxReader
implements ReportReader {
    private DataReport destReport;
    private InputStream in;

    public ReportSaxReader(DataReport destReport, InputStream in, ReportDataSource option) {
        this.destReport = destReport;
        this.in = in;
    }

    public ReportSaxReader(DataReport report, File file, ReportDataSource option) {
        this.destReport = report;
        try {
            this.in = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((InputStream)this.in);
    }

    @Override
    public DataReport read() {
        Document doc = XMLHelper.readXML(this.in);
        if (doc == null) {
            return this.destReport;
        }
        for (Object node : doc.getRootElement().elements()) {
            Element element = (Element)node;
            DataRow row = this.destReport.createRow();
            row.fromXML(element);
            this.destReport.addRow(row);
        }
        return this.destReport;
    }

    @Override
    public String getType() {
        return "SAX";
    }
}

