/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datareport;

import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportMetaData;
import com.pmease.quickbuild.util.DateRange;
import java.util.ArrayList;
import org.joda.time.DateTime;

public class StatisticsReport
extends DataReport {
    private static final long serialVersionUID = 1L;

    public StatisticsReport(ReportMetaData meta) {
        super(meta);
    }

    public String getOutputFile(Build build) {
        DateRange dateRange = new DateRange(build.getBeginDate(), build.getEndDate());
        String[] files = this.getOutputFiles(dateRange);
        return files[files.length - 1];
    }

    public String[] getOutputFiles(DateRange dateRange) {
        int months = dateRange.months();
        DateTime dt = new DateTime((Object)dateRange.getBeginDate());
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i <= months; ++i) {
            StringBuilder sb = new StringBuilder();
            sb.append(dt.getYear() + "/" + dt.getMonthOfYear());
            sb.append("/" + this.getOutputName());
            result.add(sb.toString());
            dt = dt.plusMonths(1);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public StatisticsReport newInstance(boolean withOldValues) {
        StatisticsReport report = new StatisticsReport(this.getMeta());
        if (withOldValues) {
            report.setRows(new ArrayList<DataRow>(this.getRows()));
        }
        return report;
    }
}

