/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datareport;

import com.google.common.base.Objects;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataColumn;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportMetaData;
import com.pmease.quickbuild.plugin.report.engine.datareport.StatsDataColumn;
import com.pmease.quickbuild.plugin.report.engine.datatype.BooleanType;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.datatype.EnumType;

public class ReportStatsMetaData
extends ReportMetaData {
    private static final long serialVersionUID = 1L;
    private ReportMetaData parent;

    public ReportStatsMetaData() {
    }

    public static String getFileSuffix() {
        return ".sml";
    }

    @Override
    public String getOutputName() {
        return this.getReportName() + ReportStatsMetaData.getFileSuffix();
    }

    public ReportStatsMetaData(ReportMetaData meta) {
        this(meta, false);
    }

    public ReportStatsMetaData(ReportMetaData meta, boolean withDefault) {
        this.parent = meta;
        if (withDefault) {
            this.fromReportMeta(meta);
        } else {
            this.setReportName(meta.getReportName());
            this.setGroup(meta.getGroup());
        }
    }

    @Override
    public StatsDataColumn createDefaultColumn() {
        return new StatsDataColumn();
    }

    protected ReportStatsMetaData fromReportMeta(ReportMetaData meta) {
        this.parent = meta;
        this.setReportName(meta.getReportName());
        this.setGroup(meta.getGroup());
        StatsDataColumn column = new StatsDataColumn("TOTALS", DataTypes.LONG, "stats.TOTALS + 1");
        this.addColumn(column);
        for (DataColumn c : meta.getColumns()) {
            if (c.getDataType().isIdType() || c.getColumnName().equalsIgnoreCase("buildId")) continue;
            if (c.getDataType().isNumericType()) {
                column = this.createDefaultColumn();
                column.setColumnName(c.getColumnName());
                column.setDataType(c.getDataType());
                column.setValueExpression("stats." + c.getColumnName() + " + source." + c.getColumnName());
                this.addColumn(column);
                continue;
            }
            if (c.getDataType() instanceof BooleanType) {
                column = this.createDefaultColumn();
                String columnName = c.getColumnName() + "_TRUE";
                column.setColumnName(columnName);
                column.setDataType(DataTypes.INTEGER);
                column.setValueExpression("source." + c.getColumnName() + " ? stats." + columnName + " + 1 : stats." + columnName);
                this.addColumn(column);
                column = this.createDefaultColumn();
                columnName = c.getColumnName() + "_FALSE";
                column.setColumnName(columnName);
                column.setDataType(DataTypes.INTEGER);
                column.setValueExpression("source." + c.getColumnName() + " ? stats." + columnName + " : stats." + columnName + " + 1");
                this.addColumn(column);
                continue;
            }
            if (!(c.getDataType() instanceof EnumType)) continue;
            EnumType enumType = (EnumType)c.getDataType();
            for (String e : enumType.getValues()) {
                String columnName = c.getColumnName() + "_" + e;
                column = this.createDefaultColumn();
                column.setColumnName(columnName);
                column.setDataType(DataTypes.INTEGER);
                StringBuilder sb = new StringBuilder();
                sb.append("source.").append(c.getColumnName()).append(" == \"").append(e).append("\"").append(" ? stats.").append(columnName).append(" + 1 : stats.").append(columnName);
                column.setValueExpression(sb.toString());
                this.addColumn(column);
            }
        }
        return this;
    }

    public ReportMetaData getParent() {
        return this.parent;
    }

    public void setParent(ReportMetaData parent) {
        this.parent = parent;
    }

    @Override
    public String getElementName() {
        return "stats";
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof ReportStatsMetaData)) {
            return false;
        }
        ReportStatsMetaData rhs = (ReportStatsMetaData)other;
        return Objects.equal((Object)this.getReportName(), (Object)rhs.getReportName()) && Objects.equal((Object)((Object)this.getGroup()), (Object)((Object)rhs.getGroup())) && Objects.equal((Object)this.getDataColumns().size(), (Object)rhs.getDataColumns().size());
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getReportName(), this.getGroup(), this.getDataColumns().size()});
    }

    @Override
    public String getType() {
        return "DEFAULT";
    }
}

