/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datareport;

import com.pmease.quickbuild.plugin.report.engine.datareport.DataColumn;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportMetaData;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportStatsMetaData;
import com.pmease.quickbuild.plugin.report.engine.datatype.BooleanType;
import com.pmease.quickbuild.plugin.report.engine.datatype.EnumType;
import com.pmease.quickbuild.plugin.report.engine.exception.ColumnNotFoundException;
import java.util.HashMap;
import java.util.Map;

public class ReportStats
extends DataReport {
    private static final long serialVersionUID = 1L;

    public ReportStats(ReportStatsMetaData meta) {
        super(meta);
    }

    @Override
    public String getOutputName() {
        return this.getReportName() + ReportStatsMetaData.getFileSuffix();
    }

    @Override
    public String getType() {
        return "DEFAULT";
    }

    public Map<String, Object> getStats() {
        if (this.getRowsCount() == 0) {
            this.addRow();
        }
        DataRow row = this.getRow(0);
        ReportMetaData meta = this.getMeta().getParent();
        Map<String, Object> map = row.toMap();
        for (DataColumn column : meta.getColumns()) {
            try {
                if (column.getDataType() instanceof BooleanType) {
                    HashMap<String, Object> m = new HashMap<String, Object>();
                    m.put("TRUE", row.getValue(column.getColumnName() + "_TRUE"));
                    m.put("FALSE", row.getValue(column.getColumnName() + "_FALSE"));
                    map.put(column.getColumnName(), m);
                    continue;
                }
                if (!(column.getDataType() instanceof EnumType)) continue;
                EnumType eType = (EnumType)column.getDataType();
                String[] names = eType.getValues();
                HashMap<String, Object> m = new HashMap<String, Object>();
                for (String name : names) {
                    m.put(name, row.getValue(column.getColumnName() + "_" + name));
                }
                map.put(column.getColumnName(), m);
            }
            catch (ColumnNotFoundException e) {
                // empty catch block
            }
        }
        return map;
    }

    public Object getValue(int index) {
        if (this.getRowsCount() == 0) {
            return this.getMeta().getColumn(index).getDataType().getDefaultValue();
        }
        return this.getRow(0).getValue(index);
    }

    public Object getValue(String columnName) {
        if (this.getRowsCount() == 0) {
            return this.getMeta().getColumn(columnName).getDataType().getDefaultValue();
        }
        return this.getRow(0).getValue(columnName);
    }

    @Override
    public ReportStatsMetaData getMeta() {
        return (ReportStatsMetaData)super.getMeta();
    }
}

