/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datareport;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.migration.MigrationHelper;
import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataColumn;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportGroup;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportStatsMetaData;
import com.pmease.quickbuild.plugin.report.engine.datastore.StatsQuery;
import com.pmease.quickbuild.plugin.report.engine.datatype.EnumType;
import com.pmease.quickbuild.plugin.report.engine.datatype.IdType;
import com.pmease.quickbuild.plugin.report.engine.datatype.PercentType;
import com.pmease.quickbuild.plugin.report.engine.exception.ColumnNotFoundException;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.AbstractTypedXMLObject;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import com.pmease.quickbuild.plugin.report.engine.util.CaseInsensitiveMap;
import com.pmease.quickbuild.plugin.report.engine.util.TypedObjects;
import com.pmease.quickbuild.plugin.report.engine.util.XMLHelper;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.dom4j.Node;
import org.hibernate.util.SerializationHelper;

public class ReportMetaData
extends AbstractTypedXMLObject {
    private static final long serialVersionUID = 1L;
    @Alias(name="name")
    @XStreamAlias(value="name")
    @XStreamAsAttribute
    private String reportName;
    @XStreamAlias(value="columns")
    @XStreamImplicit(itemFieldName="column")
    private Map<String, DataColumn> dataColumns = CaseInsensitiveMap.create(new LinkedHashMap());
    @XStreamOmitField
    private BiMap<String, Integer> indexes = HashBiMap.create();
    @Alias(name="group")
    @XStreamAsAttribute
    private ReportGroup group = ReportGroup.BUILD;
    @XStreamOmitField
    private ReportStatsMetaData statsMeta;
    @Alias
    @XStreamOmitField
    private String initSql;
    @XStreamOmitField
    private final DataColumn idColumn = this.createIdColumn();

    public ReportMetaData() {
        this.idColumn.setUpdatable(false);
        this.addColumn(this.idColumn);
    }

    protected DataColumn createIdColumn() {
        DataColumn column = this.createDefaultColumn();
        column.setColumnName("ID");
        column.setDataType(new IdType());
        column.setSqlType("BIGINT");
        column.setNullable(false);
        column.setSearchable(false);
        return column;
    }

    public ReportMetaData newInstance() {
        return (ReportMetaData)SerializationHelper.clone((Serializable)this);
    }

    public DataColumn getIdColumn() {
        return this.idColumn;
    }

    @Override
    public void fromXML(Element element) {
        super.fromXML(element);
        List elements = element.elements("column");
        for (Element e : elements) {
            DataColumn column = TypedObjects.createTypedObject(e, DataColumn.class, this.createDefaultColumn(), new Object[0]);
            column.fromXML(e);
            this.addColumn(column);
        }
        Element e = element.element("stats");
        if (e != null) {
            boolean withDefault = XMLHelper.getBoolean((Node)e, "withDefault", true);
            this.statsMeta = new ReportStatsMetaData(this, withDefault);
            this.statsMeta.fromXML(e);
        } else if (!(this instanceof ReportStatsMetaData)) {
            this.statsMeta = new ReportStatsMetaData(this, true);
        }
        if (Strings.isNullOrEmpty((String)this.initSql)) {
            this.initSql = this.getDefaultSql();
        }
    }

    protected String getDefaultSql() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.format("CREATE TABLE IF NOT EXISTS %s ( ID LONG NOT NULL AUTO_INCREMENT PRIMARY KEY", this.reportName));
        StringBuffer indexBuffer = new StringBuffer();
        for (DataColumn each : this.getColumns()) {
            if (each == this.idColumn) continue;
            sb.append("\n, ").append(each.getColumnName()).append(" ").append(each.getSqlType());
            if (each.getDataType().isPrimitiveType() || !each.isNullable()) {
                sb.append(" NOT NULL ");
            }
            if (!each.isPrimary() && !(each.getDataType() instanceof EnumType) && !each.isIndexed()) continue;
            indexBuffer.append(String.format("\nCREATE INDEX IF NOT EXISTS IDX_%s_%s ON %s (%s);", this.reportName, each.getColumnName(), this.reportName, each.getColumnName()));
        }
        return new StringBuffer().append(sb.toString()).append(");").append(indexBuffer.toString()).toString();
    }

    @Override
    public Element toXML() {
        Element element = super.toXML();
        element.remove(element.attribute("initSql"));
        for (DataColumn c : this.dataColumns.values()) {
            element.add(c.toXML());
        }
        if (this.statsMeta != null) {
            // empty if block
        }
        return element;
    }

    @Override
    public String getElementName() {
        return "meta";
    }

    public int getColumnsCount() {
        return this.dataColumns.size();
    }

    public static String getFileSuffix() {
        return ".xml";
    }

    public String getOutputName() {
        return this.reportName + ReportMetaData.getFileSuffix();
    }

    public DataColumn[] getPrimaryColumns() {
        ArrayList result = Lists.newArrayList();
        for (DataColumn each : this.getColumns()) {
            if (!each.isPrimary()) continue;
            result.add(each);
        }
        return (DataColumn[])Iterables.toArray((Iterable)result, DataColumn.class);
    }

    public String[] getPrimaryKeys() {
        ArrayList list = Lists.newArrayList();
        for (DataColumn each : this.getColumns()) {
            if (!each.isPrimary()) continue;
            list.add(each.getColumnName());
        }
        return (String[])Iterables.toArray((Iterable)list, String.class);
    }

    protected synchronized void rebuildIndexes() {
        this.indexes.clear();
        int i = 0;
        for (String each : this.dataColumns.keySet()) {
            this.indexes.put((Object)each, (Object)i);
            ++i;
        }
    }

    public synchronized void removeColumn(DataColumn column) {
        if (this.hasColumn(column.getColumnName())) {
            this.dataColumns.remove(column.getColumnName());
            this.rebuildIndexes();
        }
    }

    public synchronized void renameColumn(String oldName, String newName) {
        if (this.hasColumn(oldName)) {
            DataColumn column = this.getColumn(oldName);
            int index = this.getColumnIndex(oldName);
            column.setColumnName(newName);
            this.dataColumns.remove(oldName);
            this.dataColumns.put(newName, column);
            this.indexes.forcePut((Object)newName.toUpperCase(), (Object)index);
        }
    }

    public synchronized void addColumn(DataColumn column) {
        if (!this.hasColumn(column.getColumnName())) {
            this.indexes.put((Object)column.getColumnName().toUpperCase(), (Object)this.dataColumns.size());
        }
        this.dataColumns.put(column.getColumnName(), column);
    }

    public DataColumn[] getColumns() {
        return (DataColumn[])Iterables.toArray(this.dataColumns.values(), DataColumn.class);
    }

    public String[] getColumnNames() {
        ArrayList names = Lists.newArrayList();
        for (DataColumn each : this.getColumns()) {
            names.add(each.getColumnName());
        }
        return (String[])Iterables.toArray((Iterable)names, String.class);
    }

    public DataColumn createDefaultColumn() {
        return new DataColumn();
    }

    public DataColumn getColumn(String columnName) {
        Preconditions.checkNotNull((Object)columnName, (Object)("Column name must be defined in report " + this.reportName));
        DataColumn c = this.dataColumns.get(columnName);
        if (c == null) {
            throw new ColumnNotFoundException(columnName, this.reportName);
        }
        return c;
    }

    public DataColumn getColumn(int index) {
        String columnName = (String)this.indexes.inverse().get((Object)index);
        if (columnName == null) {
            throw new ColumnNotFoundException(index, this.reportName);
        }
        return this.dataColumns.get(columnName);
    }

    public boolean hasColumn(String columnName) {
        if (Strings.isNullOrEmpty((String)columnName)) {
            return false;
        }
        return this.dataColumns.containsKey(columnName);
    }

    public int getColumnIndex(String columnName) {
        if (Strings.isNullOrEmpty((String)columnName) || !this.indexes.containsKey((Object)columnName.toUpperCase())) {
            throw new ColumnNotFoundException(columnName, this.reportName);
        }
        return (Integer)this.indexes.get((Object)columnName.toUpperCase());
    }

    public String getReportName() {
        return this.reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public Map<String, DataColumn> getDataColumns() {
        return this.dataColumns;
    }

    public void setDataColumns(Map<String, DataColumn> dataColumns) {
        this.dataColumns = dataColumns;
    }

    public DataColumn getColumnByDisplayName(String displayName) {
        for (DataColumn each : this.getColumns()) {
            if (!Objects.equal((Object)displayName, (Object)each.getDisplayName())) continue;
            return each;
        }
        throw new ColumnNotFoundException(displayName, this.reportName);
    }

    public List<DataColumn> getSearchableColumns() {
        ArrayList result = Lists.newArrayList();
        for (DataColumn each : this.getColumns()) {
            if (!each.isSearchable()) continue;
            result.add(each);
        }
        return result;
    }

    public ReportGroup getGroup() {
        return this.group;
    }

    public void setGroup(ReportGroup group) {
        this.group = group;
    }

    public String getVersion() {
        return MigrationHelper.getVersion(this.getClass());
    }

    public ReportStatsMetaData getStatsMeta() {
        if (this.statsMeta == null) {
            this.statsMeta = new ReportStatsMetaData(this, true);
        }
        return this.statsMeta;
    }

    public void setStatsMeta(ReportStatsMetaData statsMeta) {
        this.statsMeta = statsMeta;
    }

    public String getInitSql() {
        return this.initSql;
    }

    public void setInitSql(String sql) {
        this.initSql = sql;
    }

    public List<StatsQuery> getStatsQueries() {
        ArrayList list = Lists.newArrayList();
        ArrayList numbers = Lists.newArrayList();
        numbers.add("COUNT(*) AS TOTALS");
        for (DataColumn each : this.getColumns()) {
            if (each == this.idColumn || each.getDataType().isIdType()) continue;
            if (!Strings.isNullOrEmpty((String)each.getSqlFunc())) {
                numbers.add(each.getSqlFunc() + "(" + each.getColumnName() + ") AS " + each.getColumnName());
                continue;
            }
            DataType dataType = each.getDataType();
            if (dataType instanceof PercentType) {
                numbers.add("AVG(" + each.getColumnName() + ") AS " + each.getColumnName());
                continue;
            }
            if (each.getDataType().isNumericType()) {
                numbers.add("SUM(" + each.getColumnName() + ") AS " + each.getColumnName());
                continue;
            }
            if (!(each.getDataType() instanceof EnumType)) continue;
            StatsQuery s = new StatsQuery();
            s.setSelectColumns(new String[]{each.getColumnName(), "COUNT(" + each.getColumnName() + ")"});
            s.setForEnum(true);
            list.add(s);
        }
        StatsQuery s = new StatsQuery();
        s.setSelectColumns((String[])Iterables.toArray((Iterable)numbers, String.class));
        list.add(s);
        return list;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ReportMetaData)) {
            return false;
        }
        ReportMetaData rhs = (ReportMetaData)other;
        return Objects.equal((Object)this.reportName, (Object)rhs.reportName) && Objects.equal((Object)((Object)this.group), (Object)((Object)rhs.group)) && Objects.equal((Object)this.dataColumns.size(), (Object)rhs.dataColumns.size());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.reportName, this.group, this.dataColumns.size()});
    }

    public String toString() {
        return this.reportName + " [" + (Object)((Object)this.group) + "]";
    }

    @Override
    public String getType() {
        return "DEFAULT";
    }
}

