/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datareport;

import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataColumn;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportStats;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportStatsEvaluator;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportStatsMetaData;
import com.pmease.quickbuild.plugin.report.engine.datareport.StatsDataColumn;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.AbstractTypedXMLObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultStatsEvaluator
extends AbstractTypedXMLObject
implements ReportStatsEvaluator {
    private static final long serialVersionUID = 1L;

    @Override
    public void evaluate(List<DataRow> source, ReportStats stats) {
        if (source == null || source.isEmpty()) {
            return;
        }
        DataRow dest = stats.getRow(0);
        ReportStatsMetaData meta = stats.getMeta();
        ScriptEngine em = (ScriptEngine)Quickbuild.getInstance(ScriptEngine.class);
        HashMap<String, Map<String, Object>> context = new HashMap<String, Map<String, Object>>();
        for (DataRow row : source) {
            context.put("source", row.toMap());
            for (DataColumn c : meta.getColumns()) {
                StatsDataColumn column = (StatsDataColumn)c;
                if (column.isIgnore()) continue;
                String expression = column.getValueExpression();
                context.put("stats", stats.getStats());
                Object value = em.evaluate(expression, context);
                dest.setValue(c.getColumnName(), value);
            }
        }
    }

    @Override
    public String getType() {
        return "DEFAULT";
    }

    @Override
    public String getElementName() {
        return "evaluator";
    }
}

