/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datareport;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataColumn;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.Order;
import java.util.Comparator;
import java.util.List;

public class DataRowComparator
implements Comparator<DataRow> {
    private List<Order> orders = Lists.newArrayList();

    public DataRowComparator(List<Order> orders) {
        this.orders = orders;
    }

    public DataRowComparator(DataColumn[] columns) {
        this(columns, true);
    }

    public DataRowComparator(DataColumn[] columns, boolean asc) {
        for (DataColumn each : columns) {
            this.orders.add(new Order(each.getColumnName(), asc));
        }
    }

    public DataRowComparator(DataColumn column, boolean asc) {
        this.orders.add(new Order(column.getColumnName(), asc));
    }

    @Override
    public int compare(DataRow row1, DataRow row2) {
        if (row1 == row2 || this.orders == null || this.orders.isEmpty()) {
            return 0;
        }
        for (Order each : this.orders) {
            int asc;
            int result = 1;
            int n = asc = each.isAscending() ? 1 : -1;
            if (row1 == null) {
                return result * asc;
            }
            if (row2 == null) {
                return result * asc;
            }
            Object value1 = row1.getValue(each.getColumn());
            Object value2 = row2.getValue(each.getColumn());
            result = row1.getReport().getDataType(each.getColumn()).compare(value1, value2);
            if (result == 0) continue;
            return result * asc;
        }
        return 0;
    }

    public boolean isEqual(DataRow row1, DataRow row2) {
        return this.compare(row1, row2) == 0;
    }
}

