/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datareport;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataColumn;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportMetaData;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.datatype.EnumType;
import com.pmease.quickbuild.plugin.report.engine.exception.ColumnNotFoundException;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.AbstractTypedXMLObject;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class DataRow
extends AbstractTypedXMLObject {
    private static final long serialVersionUID = 1L;
    private final Object[] values;
    @XStreamOmitField
    private final DataReport report;

    public DataRow(DataReport report, Object[] values) {
        Validate.isTrue((values.length == report.getColumnsCount() ? 1 : 0) != 0, (String)"The values length should be equal with the report columns length.");
        this.report = report;
        this.values = values;
    }

    public DataRow(DataReport report) {
        this(report, new Object[report.getColumnsCount()]);
    }

    public Object getNullableValue(String columnName) {
        int index = this.report.getMeta().getColumnIndex(columnName);
        return this.values[index];
    }

    public Object getNullableValue(int index) {
        if (index < 0 || index >= this.report.getColumnsCount()) {
            throw new ColumnNotFoundException(index, this.report.getReportName());
        }
        return this.values[index];
    }

    public Object getValue(String columnName) {
        Object obj = this.getNullableValue(columnName);
        if (obj == null) {
            return this.report.getDataType(columnName).getDefaultValue();
        }
        return obj;
    }

    public Object getValue(int index) {
        Object obj = this.getNullableValue(index);
        if (obj == null) {
            return this.report.getDataType(index).getDefaultValue();
        }
        return obj;
    }

    public void setValue(String columnName, Object value) {
        int index = this.report.getMeta().getColumnIndex(columnName);
        this.setValue(index, value);
    }

    public void setValue(int index, Object value) {
        if (index < 0 || index >= this.report.getColumnsCount()) {
            throw new ColumnNotFoundException(index, this.report.getReportName());
        }
        DataType dataType = this.report.getDataType(index);
        this.values[index] = dataType.typeCast(value);
    }

    public String getString(String columnName) {
        return this.getValueAsString(columnName);
    }

    public int getInt(String columnName) {
        return (Integer)DataTypes.INTEGER.typeCast(this.getValue(columnName));
    }

    public long getLong(String columnName) {
        return (Long)DataTypes.LONG.typeCast(this.getValue(columnName));
    }

    public boolean getBoolean(String columnName) {
        return (Boolean)DataTypes.BOOLEAN.typeCast(this.getValue(columnName));
    }

    public double getDouble(String columnName) {
        return (Double)DataTypes.DOUBLE.typeCast(this.getValue(columnName));
    }

    public String getValueAsString(String columnName) {
        return this.getValueAsString(columnName, "");
    }

    public String getValueAsString(String columnName, String defaultValue) {
        Object value = this.getValue(columnName);
        DataType dataType = this.report.getDataType(columnName);
        String str = dataType.asString(value);
        if (Strings.isNullOrEmpty((String)str)) {
            return defaultValue;
        }
        return str;
    }

    public String getValueAsString(int index) {
        Object value = this.getValue(index);
        DataType dataType = this.report.getDataType(index);
        return dataType.asString(value);
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ReportMetaData meta = this.report.getMeta();
        for (DataColumn c : meta.getColumns()) {
            if (c == meta.getIdColumn()) {
                map.put("id", this.getId());
            }
            if (c.getDataType().isCollectionType()) {
                map.put(c.getColumnName() + "__LIST", this.getValueAsString(c.getColumnName()));
            }
            Object value = this.getValue(c.getColumnName());
            if (c.getDataType() instanceof EnumType) {
                value = c.getDataType().asString(value);
            }
            map.put(c.getColumnName(), value);
        }
        return map;
    }

    public void fromMap(Map<String, Object> map) {
        if (map == null) {
            return;
        }
        ReportMetaData meta = this.report.getMeta();
        for (DataColumn each : meta.getColumns()) {
            String key = each.getColumnName();
            if (!map.containsKey(key)) continue;
            this.setValue(key, map.get(key));
        }
    }

    @Override
    public void fromXML(Element node) {
        ReportMetaData meta = this.report.getMeta();
        for (DataColumn column : meta.getColumns()) {
            Object value = column.getDataType().readFromNode(node, column.getColumnName(), this.report.getLocale());
            this.setValue(column.getColumnName(), value);
        }
    }

    @Override
    public Element toXML() {
        Element element = DocumentHelper.createElement((String)this.getElementName());
        Locale locale = this.report.getLocale();
        for (int i = 0; i < this.report.getColumnsCount(); ++i) {
            Object value = this.values[i];
            if (value == null) continue;
            DataColumn c = this.report.getMeta().getColumn(i);
            c.getDataType().writeToNode(element, c.getColumnName(), value, locale);
        }
        return element;
    }

    public Object[] getValues() {
        return this.values;
    }

    public Long getId() {
        return this.getLong("ID");
    }

    public void setId(long id) {
        this.setValue("ID", (Object)id);
    }

    public DataReport getReport() {
        return this.report;
    }

    public String getRowKeyString(String[] columnNames) {
        ArrayList columns = Lists.newArrayList();
        for (String each : columnNames) {
            columns.add(this.report.getColumn(each));
        }
        return this.getRowKeyString((DataColumn[])Iterables.toArray((Iterable)columns, DataColumn.class));
    }

    public String getRowKeyString(DataColumn[] columns) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < columns.length; ++i) {
            DataColumn c = columns[i];
            String str = this.getValueAsString(c.getColumnName());
            if (str == null) {
                str = "";
            }
            sb.append(str);
            if (i + 1 >= columns.length) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    public String getRowKeyString() {
        DataColumn[] primaries = this.getReport().getMeta().getPrimaryColumns();
        return this.getRowKeyString(primaries);
    }

    public void fromBean(Object obj, boolean ignoreNull) {
        if (obj == null) {
            return;
        }
        List fields = BeanUtils.getFields(obj.getClass());
        for (Field each : fields) {
            String name = each.getName();
            if (!this.report.getMeta().hasColumn(name)) continue;
            try {
                Object value = PropertyUtils.getProperty((Object)obj, (String)name);
                boolean bl = value == null ? !ignoreNull : true;
                boolean needUpdate = bl;
                if (!needUpdate) continue;
                this.setValue(name, value);
            }
            catch (Exception e) {
                throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
            }
        }
    }

    public void toBean(Object obj, boolean ignoreNull) {
        if (obj == null) {
            return;
        }
        List fields = BeanUtils.getFields(obj.getClass());
        for (Field each : fields) {
            String name = each.getName();
            if (!this.report.getMeta().hasColumn(name)) continue;
            Object value = this.getNullableValue(name);
            boolean b = value == null ? !ignoreNull : true;
            try {
                if (!b) continue;
                PropertyUtils.setProperty((Object)obj, (String)name, (Object)value);
            }
            catch (Exception e) {
                throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
            }
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof DataRow)) {
            return false;
        }
        DataRow rhs = (DataRow)other;
        return new EqualsBuilder().append((Object)this.getId(), (Object)rhs.getId()).append(this.values, rhs.values).append((Object)this.report.getMeta(), (Object)rhs.report.getMeta()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getId()).append(this.values).append((Object)this.report.getMeta()).toHashCode();
    }

    public String toString() {
        return this.dump();
    }

    public String dump() {
        StringBuffer sb = new StringBuffer();
        List<DataColumn> columns = this.report.getColumns();
        for (int i = 0; i < this.report.getColumnsCount(); ++i) {
            DataColumn c = columns.get(i);
            sb.append(c.getColumnName()).append(": ").append(this.values[i]).append("\n");
        }
        return sb.toString();
    }

    @Override
    public String getElementName() {
        return "row";
    }

    @Override
    public String getType() {
        return "DEFAULT";
    }
}

