/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datareport;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataColumn;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReportMigrator;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRowComparator;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportMetaData;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportStats;
import com.pmease.quickbuild.plugin.report.engine.datareport.io.DefaultReportWriter;
import com.pmease.quickbuild.plugin.report.engine.datareport.io.ReportStaxReader;
import com.pmease.quickbuild.plugin.report.engine.datastore.Order;
import com.pmease.quickbuild.plugin.report.engine.datatype.AbstractCollectionType;
import com.pmease.quickbuild.plugin.report.engine.datatype.BooleanType;
import com.pmease.quickbuild.plugin.report.engine.datatype.StringType;
import com.pmease.quickbuild.plugin.report.engine.exception.ColumnNotFoundException;
import com.pmease.quickbuild.plugin.report.engine.exception.ReportException;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.AbstractTypedXMLObject;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import com.pmease.quickbuild.plugin.report.engine.util.XMLHelper;
import com.pmease.quickbuild.plugin.report.engine.util.csv.CSVWriter;
import com.pmease.quickbuild.util.ClassUtils;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.LockUtils;
import com.pmease.quickbuild.util.Pair;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataReport
extends AbstractTypedXMLObject {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(DataReport.class);
    @XStreamOmitField
    private final ReportMetaData meta;
    private List<DataRow> rows = new ArrayList<DataRow>();
    private Locale locale = Locale.getDefault();
    private String version;

    public DataReport(ReportMetaData meta) {
        this.meta = meta;
    }

    public String getReportName() {
        return this.meta.getReportName();
    }

    public String getOutputName() {
        return this.meta.getOutputName();
    }

    public List<DataColumn> getColumns() {
        return Arrays.asList(this.meta.getColumns());
    }

    public int getColumnsCount() {
        return this.getColumns().size();
    }

    public DataColumn getColumn(int index) {
        return this.meta.getColumn(index);
    }

    public DataColumn getColumn(String columnName) {
        return this.meta.getColumn(columnName);
    }

    public int getRowsCount() {
        return this.rows.size();
    }

    public DataType getDataType(String columnName) {
        return this.meta.getColumn(columnName).getDataType();
    }

    public DataType getDataType(int index) {
        return this.meta.getColumn(index).getDataType();
    }

    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    public DataRow getRow(int index) {
        return this.rows.get(index);
    }

    public DataRow createRow(Object[] values) {
        return new DataRow(this, values);
    }

    public DataRow createRow() {
        return new DataRow(this, new Object[this.getColumnsCount()]);
    }

    public DataRow addRow(Object[] values) {
        DataRow row = this.createRow(values);
        this.rows.add(row);
        row.setId(this.getRowsCount());
        return row;
    }

    public DataRow addRow() {
        return this.addRow(new Object[this.getColumnsCount()]);
    }

    public DataRow addRow(DataRow row) {
        if (row == null) {
            return this.addRow();
        }
        DataRow destRow = null;
        if (this.meta.equals(row.getReport().getMeta())) {
            destRow = this.addRow(row.getValues());
        } else {
            destRow = this.addRow();
            for (DataColumn column : this.meta.getColumns()) {
                try {
                    destRow.setValue(column.getColumnName(), row.getValue(column.getColumnName()));
                }
                catch (ColumnNotFoundException e) {
                    // empty catch block
                }
            }
        }
        return destRow;
    }

    public void removeRow(int index) {
        this.rows.remove(index);
    }

    public void removeRow(DataRow row) {
        this.rows.remove(row);
    }

    public DataRow findRow(String matchCondition) {
        for (DataRow sourceRow : this.rows) {
            boolean accept = (Boolean)ReportHelper.evaluate(matchCondition, sourceRow.toMap());
            if (!accept) continue;
            return sourceRow;
        }
        return null;
    }

    public DataRow findRow(Predicate<DataRow> predicate) {
        return (DataRow)Iterables.find(this.rows, predicate, null);
    }

    public void clear() {
        this.rows.clear();
    }

    public DataRow findRow(Map<String, Object> emContext, String matchCondition) {
        if (StringUtils.isEmpty((String)matchCondition)) {
            matchCondition = this.createDefaultMatchCondition();
        }
        for (DataRow row : this.rows) {
            emContext.put("current", row.toMap());
            boolean match = (Boolean)ReportHelper.evaluate(matchCondition, emContext);
            if (!match) continue;
            return row;
        }
        return null;
    }

    public DataRow findRow(DataRow sourceRow, String matchCondition) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("source", sourceRow.toMap());
        return this.findRow(map, matchCondition);
    }

    public DataRow findRow(DataRow sourceRow, DataColumn[] compareColumns) {
        if (compareColumns == null) {
            compareColumns = this.meta.getPrimaryColumns();
        }
        DataRowComparator comparator = new DataRowComparator(compareColumns);
        for (DataRow row : this.rows) {
            if (!comparator.isEqual(sourceRow, row)) continue;
            return row;
        }
        return null;
    }

    public DataRow findRow(Pair<String, Object>[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        ArrayList<Pair<String, Object>> cached = new ArrayList<Pair<String, Object>>();
        for (int i = 0; i < values.length; ++i) {
            if (!this.getMeta().hasColumn((String)values[i].getFirst())) continue;
            cached.add(values[i]);
        }
        if (cached.isEmpty()) {
            return null;
        }
        for (DataRow row : this.rows) {
            boolean found = true;
            for (Pair pair : cached) {
                Object v1 = row.getValue((String)pair.getFirst());
                Object v2 = pair.getSecond();
                DataColumn column = this.getMeta().getColumn((String)pair.getFirst());
                if (column.getDataType().isEqual(v1, v2)) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return row;
        }
        return null;
    }

    public DataRow findRow(DataRow sourceRow, boolean wholeRowMatch) {
        DataColumn[] columns = null;
        columns = wholeRowMatch ? this.getColumns().toArray(new DataColumn[0]) : this.meta.getPrimaryColumns();
        return this.findRow(sourceRow, columns);
    }

    protected String createDefaultMatchCondition() {
        DataColumn[] primaries = this.meta.getPrimaryColumns();
        StringBuffer sb = new StringBuffer();
        for (DataColumn column : primaries) {
            sb.append("(current." + column.getColumnName() + " == " + "source" + "." + column.getColumnName() + ")");
            sb.append(" && ");
        }
        sb.append("true");
        logger.debug("createDefaultMatchCondition() - " + sb.toString());
        return sb.toString();
    }

    public List<DataRow> getRows() {
        return this.rows;
    }

    public void setRows(List<DataRow> rows) {
        this.rows = rows;
    }

    public ReportMetaData getMeta() {
        return this.meta;
    }

    public void sortRows(List<Order> orders) {
        Collections.sort(this.rows, new DataRowComparator(orders));
    }

    public void sortRows(String sortColumnNames, boolean asc) {
        if (StringUtils.isEmpty((String)sortColumnNames)) {
            return;
        }
        ArrayList tokens = Lists.newArrayList((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)sortColumnNames));
        DataColumn[] columns = new DataColumn[tokens.size()];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = this.meta.getColumn((String)tokens.get(i));
        }
        Collections.sort(this.rows, new DataRowComparator(columns, asc));
    }

    public void setMaxRows(int maxRows) {
        if (maxRows <= 0) {
            return;
        }
        int endIndex = Math.min(maxRows, this.rows.size());
        ArrayList<DataRow> newRows = new ArrayList<DataRow>();
        newRows.addAll(this.rows.subList(0, endIndex));
        this.rows = newRows;
    }

    public DataReport newInstance(boolean withValues) {
        DataReport destReport = (DataReport)ClassUtils.instantiateClass(this.getClass(), (Object[])new Object[]{this.meta});
        if (withValues) {
            destReport.setRows(new ArrayList<DataRow>(this.rows));
        }
        return destReport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToXML(OutputStream out) {
        DefaultReportWriter writer = new DefaultReportWriter(out);
        try {
            writer.write(this);
        }
        finally {
            writer.close();
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    public void saveToXML(File file) {
        Lock writeLock = LockUtils.lockForWrite((File)file);
        try {
            this.saveToXML(new FileOutputStream(file));
        }
        catch (FileNotFoundException e) {
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromXML(InputStream in) {
        ReportStaxReader reader = new ReportStaxReader(this, in);
        try {
            reader.read();
        }
        finally {
            reader.close();
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public void loadFromXML(File file) {
        if (!file.exists()) {
            return;
        }
        Lock lock = LockUtils.lockForRead((File)file);
        try {
            this.loadFromXML(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void fromXML(Element element) throws ReportException {
        String localeStr = XMLHelper.getString((Node)element, "locale");
        this.locale = ReportHelper.getLocale(localeStr);
        List elements = element.elements();
        for (Element node : elements) {
            DataRow row = this.addRow();
            row.fromXML(node);
        }
    }

    @Override
    public Element toXML() throws ReportException {
        Element element = super.toXML();
        element.addAttribute("name", this.meta.getReportName());
        element.addAttribute("version", this.getVersion());
        element.addAttribute("locale", this.locale.toString());
        for (DataRow row : this.rows) {
            element.add(row.toXML());
        }
        return element;
    }

    private void toCSV(Writer w, char delim) throws IOException {
        CSVWriter writer = new CSVWriter(w, delim);
        DataColumn[] columns = this.meta.getColumns();
        ArrayList fields = Lists.newArrayListWithCapacity((int)columns.length);
        for (DataColumn each : columns) {
            fields.add(each.getDisplayName());
        }
        writer.writeLine(fields);
        for (DataRow each : this.getRows()) {
            ArrayList list = Lists.newArrayListWithCapacity((int)columns.length);
            for (DataColumn column : columns) {
                String v = column.getDataType().asString(each.getValue(column.getColumnName()));
                if (v == null) {
                    v = "";
                }
                list.add(v);
            }
            writer.writeLine(list);
        }
        w.flush();
    }

    public void toCSV(Writer w) {
        try {
            this.toCSV(w, ',');
        }
        catch (IOException e) {
            throw new ReportException(e);
        }
    }

    public void toTSV(Writer w) {
        try {
            this.toCSV(w, '\t');
        }
        catch (IOException e) {
            throw new ReportException(e);
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getType() {
        return "DEFAULT";
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.meta, this.version, this.rows});
    }

    public boolean equals(Object obj) {
        boolean equal;
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof DataReport)) {
            return false;
        }
        DataReport other = (DataReport)obj;
        boolean bl = equal = Objects.equal((Object)this.meta, (Object)other.meta) && Objects.equal((Object)this.version, (Object)other.version) && Objects.equal((Object)this.locale, (Object)other.locale);
        if (!equal) {
            return false;
        }
        DataColumn[] columns = this.meta.getColumns();
        for (int i = 0; i < this.getRowsCount(); ++i) {
            DataRow row2;
            DataRowComparator comparator = new DataRowComparator(columns);
            DataRow row1 = this.getRow(i);
            if (comparator.isEqual(row1, row2 = other.getRow(i))) continue;
            return false;
        }
        return true;
    }

    public ReportStats createReportStats() {
        return new ReportStats(this.meta.getStatsMeta());
    }

    public boolean containsColumn(DataColumn column) {
        for (DataColumn aColumn : this.meta.getColumns()) {
            if (!aColumn.equals(column)) continue;
            return true;
        }
        return false;
    }

    public boolean containsColumn(String columnName) {
        try {
            this.meta.getColumn(columnName);
            return true;
        }
        catch (ColumnNotFoundException e) {
            return false;
        }
    }

    public List<DataRow> getFilteredRows(String filterExpression) {
        if (StringUtils.isEmpty((String)filterExpression)) {
            return this.rows;
        }
        filterExpression = StringUtils.replace((String)filterExpression, (String)"\\", (String)"\\\\");
        ArrayList<DataRow> result = new ArrayList<DataRow>();
        for (DataRow row : this.rows) {
            boolean accept = (Boolean)ReportHelper.evaluate(filterExpression, row.toMap());
            if (!accept) continue;
            result.add(row);
        }
        return result;
    }

    public void filter(String[] columnNames, String filter, boolean isContaining) {
        List<DataRow> rows = this.getFilteredRows(columnNames, filter, isContaining);
        this.setRows(rows);
    }

    public List<DataRow> getFilteredRows(String[] columnNames, String filter, boolean isContaining) {
        if (columnNames == null || columnNames.length == 0) {
            ArrayList<String> names = new ArrayList<String>();
            for (DataColumn column : this.meta.getColumns()) {
                if (!(column.getDataType() instanceof StringType)) continue;
                names.add(column.getColumnName());
            }
            columnNames = names.toArray(new String[names.size()]);
        }
        ArrayList<DataRow> rows = new ArrayList<DataRow>();
        filter = filter.toUpperCase();
        for (DataRow row : this.rows) {
            boolean found = false;
            for (String name : columnNames) {
                String str = (String)row.getValue(name);
                if (str == null || !str.toUpperCase().contains(filter)) continue;
                found = true;
            }
            if (isContaining && found) {
                rows.add(row);
                continue;
            }
            if (isContaining || found) continue;
            rows.add(row);
        }
        return rows;
    }

    public List<DataRow> getFilteredRows(String[] filterNames, Object[] values) {
        if (filterNames == null || filterNames.length == 0) {
            return this.rows;
        }
        ArrayList<DataRow> result = new ArrayList<DataRow>();
        for (DataRow row : this.rows) {
            boolean accept = true;
            for (int i = 0; i < filterNames.length; ++i) {
                if (filterNames[i].equals("id")) {
                    if (row.getId() == (Long)values[i]) {
                        accept = true;
                        break;
                    }
                    accept = false;
                    break;
                }
                DataColumn column = this.getColumn(filterNames[i]);
                if (column.getDataType().isEqual(row.getValue(filterNames[i]), values[i])) continue;
                accept = false;
                break;
            }
            if (!accept) continue;
            result.add(row);
        }
        return result;
    }

    public void filter(String filterExpression) {
        List<DataRow> rows = this.getFilteredRows(filterExpression);
        this.setRows(rows);
    }

    protected String getMergeExpression(DataColumn c) {
        if (c.getColumnName().equalsIgnoreCase("buildId")) {
            return "y";
        }
        if (c.getDataType().isNumericType()) {
            return "x + y";
        }
        if (c.getDataType() instanceof BooleanType) {
            return "x && y";
        }
        if (c.getDataType() instanceof AbstractCollectionType) {
            return "x.addAll(y); return x;";
        }
        return "y";
    }

    public void merge(DataReport another) {
        this.merge(another, this.getMeta().getPrimaryColumns());
    }

    public void merge(DataReport another, String[] columnNames) {
        DataColumn[] columns = new DataColumn[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            columns[i] = this.getColumn(columnNames[i]);
        }
        this.merge(another, columns);
    }

    public void merge(DataReport another, DataColumn[] byColumns) {
        if (another == null || another.isEmpty()) {
            return;
        }
        HashMap<String, String> expressions = new HashMap<String, String>();
        LinkedHashSet<String> keyColumnNames = new LinkedHashSet<String>();
        for (DataColumn c : byColumns) {
            keyColumnNames.add(c.getColumnName());
        }
        for (DataColumn c : this.getMeta().getColumns()) {
            if (keyColumnNames.contains(c.getColumnName())) continue;
            expressions.put(c.getColumnName(), this.getMergeExpression(c));
        }
        ScriptEngine em = (ScriptEngine)Quickbuild.getInstance(ScriptEngine.class);
        Map<String, Integer> map = this.getRowIndexMap(byColumns);
        for (DataRow row : another.getRows()) {
            DataRow dest;
            String key = row.getRowKeyString(byColumns);
            Integer index = map.get(key);
            if (index == null) {
                dest = this.addRow();
                map.put(key, this.getRowsCount() - 1);
                row.setId(this.getRowsCount());
                for (DataColumn column : this.getMeta().getColumns()) {
                    dest.setValue(column.getColumnName(), row.getValue(column.getColumnName()));
                }
                continue;
            }
            dest = this.getRow(index);
            HashMap<String, Object> context = new HashMap<String, Object>();
            for (String name : expressions.keySet()) {
                context.put("x", dest.getValue(name));
                context.put("y", row.getValue(name));
                Object value = em.evaluate((String)expressions.get(name), context);
                dest.setValue(name, value);
            }
        }
    }

    public Map<String, Integer> getRowIndexMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < this.rows.size(); ++i) {
            DataRow row = this.rows.get(i);
            map.put(row.getRowKeyString(), i);
        }
        return map;
    }

    public Map<String, Integer> getRowIndexMap(DataColumn[] columns) {
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
        for (int i = 0; i < this.rows.size(); ++i) {
            DataRow row = this.rows.get(i);
            map.put(row.getRowKeyString(columns), i);
        }
        return map;
    }

    public Map<String, Integer> getRowIndexMap(String[] columnNames) {
        DataColumn[] columns = new DataColumn[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            columns[i] = this.getColumn(columnNames[i]);
        }
        return this.getRowIndexMap(columns);
    }

    public String toString() {
        return this.getReportName();
    }

    protected Class<?> getMigratorClass() {
        return DataReportMigrator.class;
    }

    @Override
    public String getElementName() {
        return "report";
    }
}

