/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datareport;

import com.google.common.base.Ascii;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.datatype.AbstractCollectionType;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.datatype.EnumType;
import com.pmease.quickbuild.plugin.report.engine.datatype.StringType;
import com.pmease.quickbuild.plugin.report.engine.exception.MalFormedXMLException;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.AbstractTypedXMLObject;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.dom4j.Element;

public class DataColumn
extends AbstractTypedXMLObject {
    private static final long serialVersionUID = 1L;
    public static final String ID_COLUMN_NAME = "id";
    public static final String BUILD_ID_COLUMN_NAME = "buildId";
    public static final DataColumn ID_COLUMN = new DataColumn("id", DataTypes.ID, true);
    public static final DataColumn BUILD_ID_COLUMN = new DataColumn("buildId", DataTypes.ID, true);
    @Alias(name="name")
    private String columnName;
    @Alias
    private String displayName;
    @Alias
    private boolean searchable = false;
    @Alias(name="isKey")
    private boolean primary = false;
    @Alias
    private boolean indexed = false;
    @Alias
    private boolean nullable = true;
    @Alias
    private boolean updatable = true;
    @Alias(name="sqlType")
    private String sqlType;
    @Alias(name="sqlFunc")
    private String sqlFunc;
    private DataType dataType;

    public DataColumn() {
    }

    public DataColumn(String columnName, DataType dataType) {
        this(columnName, dataType, false);
    }

    public DataColumn(String columnName, DataType dataType, boolean isKey) {
        this.columnName = columnName;
        this.dataType = dataType;
        this.primary = isKey;
        this.updateArgs();
    }

    public DataColumn(DataColumn other) {
        this.columnName = other.columnName;
        this.dataType = other.dataType;
        this.primary = other.primary;
        this.sqlType = other.sqlType;
        this.nullable = other.nullable;
        this.indexed = other.indexed;
        this.updateArgs();
    }

    protected void updateArgs() {
        if (this.isPrimary()) {
            this.indexed = true;
        }
        if (Strings.isNullOrEmpty((String)this.sqlType)) {
            this.sqlType = this.dataType.getSqlType();
        }
        if (Strings.isNullOrEmpty((String)this.displayName)) {
            this.displayName = DataColumn.columnNameToDisplayName(this.columnName);
        }
    }

    static String columnNameToDisplayName(String columnName) {
        StringBuffer sb = new StringBuffer();
        ArrayList words = Lists.newArrayList();
        for (int i = 0; i < columnName.length(); ++i) {
            char c = columnName.charAt(i);
            if (Ascii.isUpperCase((char)c)) {
                String word = WordUtils.capitalize((String)sb.toString());
                words.add(word);
                sb = new StringBuffer();
            }
            sb.append(c);
        }
        String word = WordUtils.capitalize((String)sb.toString());
        words.add(word);
        return Joiner.on((String)" ").join((Iterable)words);
    }

    @Override
    public void fromXML(Element element) {
        super.fromXML(element);
        if (StringUtils.isEmpty((String)this.columnName)) {
            throw new MalFormedXMLException("DataColumn name is missing. Element: [" + element.asXML() + "]");
        }
        this.dataType = DataTypes.createDataType(element);
        this.dataType.fromXML(element);
        if (Strings.isNullOrEmpty((String)this.sqlType)) {
            this.sqlType = this.dataType.getSqlType();
        }
        if (element.attribute("searchable") == null) {
            this.updateSearchable();
        }
    }

    protected void updateSearchable() {
        if (this.dataType instanceof StringType || this.dataType instanceof EnumType || this.dataType.isNumericType() && !this.dataType.isIdType()) {
            this.setSearchable(true);
        }
        if (this.getColumnName().equalsIgnoreCase(ID_COLUMN_NAME) || this.getColumnName().equalsIgnoreCase(BUILD_ID_COLUMN_NAME)) {
            this.setSearchable(false);
        }
        if (this.dataType.isCollectionType()) {
            DataType itemType = ((AbstractCollectionType)this.dataType).getItemType();
            this.setSearchable(itemType instanceof StringType);
        }
    }

    @Override
    public Element toXML() {
        Element node = super.toXML();
        this.dataType.toXML(node);
        return node;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public DataType getItemType() {
        if (this.dataType.isCollectionType()) {
            return ((AbstractCollectionType)this.dataType).getItemType();
        }
        return null;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean isKey) {
        this.primary = isKey;
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public void setIndexed(boolean indexed) {
        this.indexed = indexed;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    public void setSearchable(boolean searchable) {
        this.searchable = searchable;
    }

    @Override
    public String getElementName() {
        return "column";
    }

    public String getSqlType() {
        return this.sqlType;
    }

    public void setSqlType(String sqlType) {
        this.sqlType = sqlType;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    public String getSqlFunc() {
        return this.sqlFunc;
    }

    public void setSqlFunc(String sqlFunc) {
        this.sqlFunc = sqlFunc;
    }

    public String getDisplayName() {
        if (Strings.isNullOrEmpty((String)this.displayName)) {
            return DataColumn.columnNameToDisplayName(this.getColumnName());
        }
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof DataColumn)) {
            return false;
        }
        DataColumn rhs = (DataColumn)other;
        return new EqualsBuilder().append((Object)this.columnName, (Object)rhs.columnName).append((Object)this.dataType, (Object)rhs.dataType).append(this.primary, rhs.primary).append(this.nullable, rhs.nullable).append(this.indexed, rhs.indexed).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.columnName).append((Object)this.dataType).append(this.primary).append(this.nullable).append(this.indexed).toHashCode();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).addValue((Object)this.columnName).add("dataType", (Object)this.dataType).add("isPrimary", this.primary).add("isIndex", this.indexed).add("sqlType", (Object)this.sqlType).toString();
    }

    @Override
    public String getType() {
        return "DEFAULT";
    }
}

