/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.contribution.web;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.ReportFilter;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererMode;
import com.pmease.quickbuild.plugin.report.engine.renderer.SessionData;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class ReportTab
extends Tab {
    private static final long serialVersionUID = 1L;
    protected final AbstractRenderer renderer;

    public ReportTab(String title, AbstractRenderer renderer) {
        super(title);
        this.renderer = renderer;
    }

    public ReportTab(AbstractRenderer renderer) {
        super(renderer.getTabName());
        this.renderer = renderer;
    }

    public Panel getPanel(String id, Map<String, String> params) {
        String str;
        RendererContext context = new RendererContext();
        String string = str = params == null ? null : params.get("reportset");
        if (!Strings.isNullOrEmpty((String)str)) {
            context.setReportSet(str);
        } else {
            context.setReportSet(this.getReportSet());
        }
        this.resetSessionData(context);
        return this.renderer.render(id, (IModel<RendererContext>)Model.of((Serializable)context));
    }

    protected String getReportSet() {
        Object[] reportsets;
        String reportset = SessionData.get().getReportSet();
        RendererMode mode = this.renderer.getMode();
        if (mode == RendererMode.BUILD) {
            reportsets = this.renderer.getCategory().getReportSetsOfBuild(Context.getBuild());
        } else if (mode == RendererMode.STATISTICS) {
            reportsets = this.renderer.getCategory().getReportSetsOfStats(Context.getConfiguration());
        } else if (mode == RendererMode.AGGREGATION_STATS || mode == RendererMode.AGGREGATION_OVERVIEW) {
            reportsets = this.renderer.getCategory().getReportSetsOfAggregation(Context.getConfiguration());
        } else {
            throw new IllegalArgumentException("Unsupported renderer mode " + (Object)((Object)mode));
        }
        Preconditions.checkArgument((reportsets.length > 0 ? 1 : 0) != 0, (Object)"Report sets should always greater than 0, or we will not display the panel.");
        if (Strings.isNullOrEmpty((String)reportset) || !ArrayUtils.contains((Object[])reportsets, (Object)reportset)) {
            return reportsets[0];
        }
        return reportset;
    }

    protected void resetSessionData(RendererContext context) {
        SessionData data = SessionData.get();
        Long currentConfiguration = Context.getConfiguration().getId();
        String currentId = this.renderer.getCategory().getId();
        String oldId = data.getCategoryId();
        if (!Objects.equal((Object)currentConfiguration, (Object)data.getConfigurationId()) || !Objects.equal((Object)currentId, (Object)oldId)) {
            data.clear();
        } else {
            ReportFilter filter = data.getFilter();
            if (this.renderer.getMode() == RendererMode.BUILD) {
                filter.setContainsFilter(null);
                filter.setAdvancedFilter(null);
                data.setFilter(filter);
            } else {
                data.setFilter(null);
            }
        }
        data.setCategoryId(currentId);
        data.setConfigurationId(currentConfiguration);
        data.setReportSet(context.getReportSet());
    }
}

