/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.contribution.web;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.extensionpoint.BuildSummaryContribution;
import com.pmease.quickbuild.extensionpoint.support.PanelCreator;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererMode;
import com.pmease.quickbuild.security.SecurityHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public abstract class ReportSummaryContribution
implements BuildSummaryContribution {
    protected abstract ReportCategory getCategory();

    protected boolean isApplicable(Build build) {
        return SecurityHelper.hasPermission((Configuration)build.getConfiguration(), (String)this.getCategory().getName().toUpperCase());
    }

    public List<PanelCreator> getPanelCreators() {
        if (!this.isApplicable(Context.getBuild())) {
            return Collections.emptyList();
        }
        AbstractRenderer[] renderers = this.getRenderers();
        if (renderers.length == 0) {
            return Collections.emptyList();
        }
        ReportCategory category = this.getCategory();
        String[] reportsets = category.getReportSetsOfBuild(Context.getBuild());
        if (reportsets.length == 0) {
            return Collections.emptyList();
        }
        ArrayList creators = Lists.newArrayList();
        for (AbstractRenderer each : renderers) {
            creators.add(new SummaryPanelCreator(each));
        }
        return creators;
    }

    public int getOrder() {
        return this.getCategory().getOrder();
    }

    protected AbstractRenderer[] getRenderers() {
        ReportCategory category = this.getCategory();
        return category.getRenderers(RendererMode.BUILD_SUMMARY);
    }

    class SummaryPanelCreator
    implements PanelCreator {
        AbstractRenderer renderer;

        SummaryPanelCreator(AbstractRenderer renderer) {
            this.renderer = renderer;
        }

        public Panel newPanel(String id) {
            RendererContext rc = new RendererContext();
            return this.renderer.render(id, (IModel<RendererContext>)Model.of((Serializable)rc));
        }
    }
}

