/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.contribution.web;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.extensionpoint.StatisticsTabContribution;
import com.pmease.quickbuild.plugin.report.engine.contribution.web.ReportTab;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererMode;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsRenderer;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.web.component.tabbedpanel.GroupingTab;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class CategoryStatisticsTab
implements StatisticsTabContribution {
    private static final long serialVersionUID = 1L;

    public abstract ReportCategory getCategory();

    public boolean isApplicable() {
        ReportCategory category = this.getCategory();
        if (!SecurityHelper.hasPermission((String)category.getName().toUpperCase())) {
            return false;
        }
        String[] reportsets = category.getReportSetsOfStats(Context.getConfiguration());
        if (reportsets.length == 0) {
            return false;
        }
        File dir = category.getCategoryDirOfStats(Context.getConfiguration());
        if (!dir.exists()) {
            return false;
        }
        AbstractRenderer[] renderers = category.getRenderers(RendererMode.STATISTICS);
        return renderers.length > 0;
    }

    public List<Tab> getTabs() {
        AbstractRenderer[] renderers;
        if (!this.isApplicable()) {
            return Collections.emptyList();
        }
        ArrayList tabs = Lists.newArrayList();
        for (AbstractRenderer each : renderers = this.getRenderers()) {
            if (each instanceof StatisticsRenderer) {
                StatisticsRenderer r = (StatisticsRenderer)each;
                tabs.addAll(r.getContributeTabs());
                continue;
            }
            tabs.add(new ReportTab(each));
        }
        if (tabs.isEmpty()) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Object[])new Tab[]{this.createGroupingTab(tabs)});
    }

    protected AbstractRenderer[] getRenderers() {
        return this.getCategory().getRenderers(RendererMode.STATISTICS);
    }

    protected Tab createGroupingTab(List<Tab> children) {
        return new GroupingTab(this.getTitle(), children);
    }

    public int getOrder() {
        ReportCategory category = this.getCategory();
        if (category == null) {
            return 999;
        }
        return category.getOrder();
    }

    protected String getTitle() {
        return this.getCategory().getName();
    }
}

