/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.contribution.web;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.extensionpoint.BuildTabContribution;
import com.pmease.quickbuild.plugin.report.engine.contribution.web.ReportTab;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererMode;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.web.component.tabbedpanel.GroupingTab;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class CategoryBuildTab
implements BuildTabContribution {
    private static final long serialVersionUID = 1L;

    protected abstract ReportCategory getCategory();

    public int getOrder() {
        if (this.getCategory() == null) {
            return 999;
        }
        return this.getCategory().getOrder();
    }

    public boolean isApplicable() {
        ReportCategory category = this.getCategory();
        if (category == null) {
            return false;
        }
        if (!SecurityHelper.hasPermission((String)category.getName().toUpperCase())) {
            return false;
        }
        String[] reportsets = category.getReportSetsOfBuild(Context.getBuild());
        if (reportsets.length == 0) {
            return false;
        }
        AbstractRenderer[] renderers = category.getRenderers(RendererMode.BUILD);
        return renderers.length > 0;
    }

    public List<Tab> getTabs() {
        AbstractRenderer[] renderers;
        if (!this.isApplicable()) {
            return Collections.emptyList();
        }
        ArrayList<Tab> tabs = new ArrayList<Tab>();
        ReportCategory category = this.getCategory();
        String[] reportsets = category.getReportSetsOfBuild(Context.getBuild());
        if (reportsets.length == 0) {
            return tabs;
        }
        ArrayList<Tab> children = new ArrayList<Tab>();
        for (AbstractRenderer renderer : renderers = category.getRenderers(RendererMode.BUILD)) {
            if (!renderer.isApplicable()) continue;
            children.add(new ReportTab(renderer));
        }
        if (children.size() > 0) {
            tabs.add((Tab)this.createGroupingTab(children));
        }
        return tabs;
    }

    protected Tab createReportTab(AbstractRenderer renderer) {
        return new ReportTab(renderer);
    }

    protected GroupingTab createGroupingTab(List<Tab> children) {
        return new GroupingTab(this.getCategory().getName(), children);
    }
}

