/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.contribution.web;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.extensionpoint.BuildOverviewContribution;
import com.pmease.quickbuild.extensionpoint.support.PanelCreator;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererMode;
import com.pmease.quickbuild.security.SecurityHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public abstract class CategoryBuildOverview
implements BuildOverviewContribution {
    protected abstract ReportCategory getCategory();

    public boolean isApplicable() {
        ReportCategory category = this.getCategory();
        if (category == null) {
            return false;
        }
        return SecurityHelper.hasPermission((String)this.getCategory().getName().toUpperCase());
    }

    public List<PanelCreator> getPanelCreators() {
        if (!this.isApplicable()) {
            return Collections.emptyList();
        }
        ArrayList creators = Lists.newArrayList();
        AbstractRenderer[] renderers = this.getCategory().getRenderers(RendererMode.DASHBOARD);
        if (renderers.length == 0) {
            return creators;
        }
        for (AbstractRenderer each : renderers) {
            if (!each.isApplicable()) continue;
            creators.add(new DashboardPanelCreator(each));
        }
        return creators;
    }

    public int getOrder() {
        return this.getCategory().getOrder();
    }

    private class DashboardPanelCreator
    implements PanelCreator {
        final AbstractRenderer renderer;

        public DashboardPanelCreator(AbstractRenderer renderer) {
            this.renderer = renderer;
        }

        public Panel newPanel(String id) {
            RendererContext context = new RendererContext();
            return this.renderer.render(id, (IModel<RendererContext>)Model.of((Serializable)context));
        }
    }
}

