/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.contribution.web;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.aggregationsupport.Aggregation;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.engine.contribution.web.CategoryStatisticsTab;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererMode;
import com.pmease.quickbuild.security.SecurityHelper;
import java.util.List;

public abstract class CategoryAggregationStatsTab
extends CategoryStatisticsTab {
    private static final long serialVersionUID = 1L;

    protected abstract boolean isAggregationApplicable(Aggregation var1);

    @Override
    public boolean isApplicable() {
        ReportCategory category = this.getCategory();
        Configuration configuration = Context.getConfiguration();
        List aggregations = configuration.findAggregations();
        boolean defined = false;
        for (Aggregation each : aggregations) {
            if (!this.isAggregationApplicable(each)) continue;
            defined = true;
            break;
        }
        if (!defined) {
            return false;
        }
        if (!SecurityHelper.hasPermission((String)category.getName().toUpperCase())) {
            return false;
        }
        String[] reportsets = category.getReportSetsOfAggregation(Context.getConfiguration());
        if (reportsets.length == 0) {
            return false;
        }
        AbstractRenderer[] renderers = this.getRenderers();
        return renderers.length > 0;
    }

    @Override
    protected AbstractRenderer[] getRenderers() {
        return this.getCategory().getRenderers(RendererMode.AGGREGATION_STATS);
    }
}

