/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.contribution.web;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.extensionpoint.ConfigurationOverviewContribution;
import com.pmease.quickbuild.extensionpoint.support.PanelCreator;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererMode;
import com.pmease.quickbuild.plugin.report.engine.renderer.aggregation.DefaultAggregationPanel;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.wicket.markup.html.panel.Panel;

public abstract class CategoryAggregationOverview
implements ConfigurationOverviewContribution {
    protected abstract ReportCategory getCategory();

    protected abstract String getToTab();

    public List<PanelCreator> getPanelCreators() {
        ReportCategory category = this.getCategory();
        if (!SecurityHelper.hasPermission((String)category.getName().toUpperCase())) {
            return Collections.emptyList();
        }
        Configuration configuration = Context.getConfiguration();
        Set names = configuration.findAggregationNames();
        if (names.size() == 0) {
            return Collections.emptyList();
        }
        AbstractRenderer[] renderers = this.getRenderers();
        if (renderers.length == 0) {
            return Collections.emptyList();
        }
        ArrayList creators = Lists.newArrayList();
        for (AbstractRenderer each : renderers) {
            creators.add(new AggregationPanelCreator(each));
        }
        return creators;
    }

    protected AbstractRenderer[] getRenderers() {
        return this.getCategory().getRenderers(RendererMode.AGGREGATION_OVERVIEW);
    }

    public int getOrder() {
        return this.getCategory().getOrder();
    }

    class AggregationPanelCreator
    implements PanelCreator {
        final AbstractRenderer renderer;

        AggregationPanelCreator(AbstractRenderer renderer) {
            this.renderer = renderer;
        }

        public Panel newPanel(String id) {
            return new DefaultAggregationPanel(id, this.renderer, Tab.title2id((String)CategoryAggregationOverview.this.getToTab()));
        }
    }
}

